/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.client;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.core.IModelManager;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BeeModelProvider
implements IBeeModelProvider {
    public static final BeeModelProvider instance = new BeeModelProvider();
    @SideOnly(value=Side.CLIENT)
    private static final ModelResourceLocation[] models = new ModelResourceLocation[EnumBeeType.values().length];

    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager) {
        String beeIconDir = "bees/default/";
        EnumBeeType beeType = BeeManager.beeRoot.getType(new ItemStack(item));
        if (beeType != null) {
            String beeTypeNameBase = beeIconDir + beeType.toString().toLowerCase(Locale.ENGLISH);
            BeeModelProvider.models[beeType.ordinal()] = this.getModelLocation("forestry", beeTypeNameBase);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + beeTypeNameBase)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(EnumBeeType type) {
        return models[type.ordinal()];
    }

    public ModelResourceLocation getModelLocation(String modID, String identifier) {
        return new ModelResourceLocation(modID + ":" + identifier, "inventory");
    }
}

