/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.liquid;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.CocktailLiquid;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Spirit implements IFluidDefinition,
ICocktailIngredientProvider
{
    NeutralSpirit("spirit.neutral", 0xFFFFFF, 0.05, 0.8f),
    Vodka("vodka", 16053751, 0.05, 0.4f),
    WhiteRum("rum.white", 15132132, 0.05, 0.4f),
    DarkRum("rum.dark", 11018752, 0.4, 0.4f),
    Whiskey("whiskey", 13594368, 0.2, 0.4f),
    CornWhiskey("whiskey.corn", 9835009, 0.2, 0.4f),
    RyeWhiskey("whiskey.rye", 16085800, 0.2, 0.4f),
    WheatWhiskey("whiskey.wheat", 14976530, 0.2, 0.4f),
    FortifiedWine("wine.fortified", 15569439, 0.2, 0.2f),
    Tequila("tequila", 16116160, 0.05, 0.4f),
    Brandy("brandy.grape", 16228128, 0.2, 0.4f),
    AppleBrandy("brandy.apple", 14985790, 0.2, 0.4f),
    PearBrandy("brandy.pear", 16696883, 0.2, 0.4f),
    ApricotBrandy("brandy.apricot", 13336387, 0.2, 0.4f),
    PlumBrandy("brandy.plum", 9511697, 0.2, 0.4f),
    CherryBrandy("brandy.cherry", 8588062, 0.2, 0.4f),
    ElderberryBrandy("brandy.elderberry", 12462919, 0.2, 0.4f),
    CitrusBrandy("brandy.citrus", 13336387, 0.2, 0.4f),
    FruitBrandy("brandy.fruit", 14985790, 0.2, 0.4f),
    Cachaca("spirit.sugarcane", 15331535, 0.1, 0.4f),
    Gin("spirit.gin", 0xF6F6F6, 0.05, 0.4f),
    AppleLiquor("liquor.apple", 0xCCCCCC, 0.05, 0.4f),
    PearLiquor("liquor.pear", 0xCCCCCC, 0.05, 0.4f),
    CherryLiquor("liquor.cherry", 0xCCCCCC, 0.05, 0.4f),
    ElderberryLiquor("liquor.elderberry", 0xCCCCCC, 0.05, 0.4f),
    ApricotLiquor("liquor.apricot", 0xCCCCCC, 0.05, 0.4f),
    FruitLiquor("liquor.fruit", 0xCCCCCC, 0.05, 0.4f);

    private final float abv;
    private final FluidType type;
    private final CocktailLiquid cocktailLiquid;

    private Spirit(String ident, int color, double transparency, float abv) {
        this.abv = abv;
        this.type = new FluidType(ident, String.format("%s.fluid.%s.%s", ExtraTrees.instance.getModId(), "Spirit", this.name()), color).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS).setTransparency(transparency);
        this.cocktailLiquid = new CocktailLiquid(this.type, abv);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public ICocktailIngredient getIngredient() {
        return this.cocktailLiquid;
    }
}

