/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gui.database;

import binnie.botany.api.BotanyAPI;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.core.BotanyCore;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageSpecies;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import net.minecraft.item.ItemStack;

public class PageSpeciesFlowerGenome
extends PageSpecies {
    public PageSpeciesFlowerGenome(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.deleteAllChildren();
        IAllele[] template = BotanyAPI.flowerRoot.getTemplate(species.getUID());
        if (template == null) {
            return;
        }
        IFlower flower = BotanyAPI.flowerRoot.templateAsIndividual(template);
        IFlowerGenome genome = flower.getGenome();
        IAlleleFlowerSpecies flowerSpecies = genome.getPrimary();
        int w = 144;
        int h = 176;
        new ControlText(this, new Area(0, 4, w, 16), I18N.localise("botany.gui.database.tab.genome.title"), TextJustification.MIDDLE_CENTER);
        ControlScrollableContent<Control> scrollable = new ControlScrollableContent<Control>(this, 4, 20, w - 8, h - 8 - 16, 12);
        Control contents = new Control(scrollable, 0, 0, w - 8 - 12, h - 8 - 16);
        int tw = w - 8 - 12;
        int w2 = 55;
        int w3 = tw - 50;
        int y = 0;
        int th = 14;
        int th2 = 18;
        new ControlText(contents, new Area(0, y, w2, th), I18N.localise("botany.gui.database.tab.genome.temp"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), flowerSpecies.getTemperature().getName(), TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += th, w2, th), I18N.localise("botany.gui.database.tab.genome.moist"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), flowerSpecies.getMoisture().getLocalisedName(false), TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += th, w2, th), I18N.localise("botany.gui.database.tab.genome.ph"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), flowerSpecies.getPH().getLocalisedName(false), TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += th, w2, th), I18N.localise("botany.gui.database.tab.genome.fertility"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), genome.getFertility() + "x", TextJustification.MIDDLE_LEFT);
        float lifespan = (float)genome.getLifespan() * 68.27f / genome.getAgeChance() / 24000.0f;
        String lifespanValue = String.format("%.2f", Float.valueOf(lifespan));
        new ControlText(contents, new Area(0, y += th, w2, th), I18N.localise("botany.gui.database.tab.genome.lifespan"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), I18N.localise("botany.gui.database.tab.genome.lifespan.value", lifespanValue), TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += th, w2, th), I18N.localise("botany.gui.database.tab.genome.nectar"), TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(w2, y, w3, th), genome.getActiveAllele(EnumFlowerChromosome.SAPPINESS).getAlleleName(), TextJustification.MIDDLE_LEFT);
        y += th;
        int x = w2;
        int tot = 0;
        for (IIndividual vid : BotanyCore.getFlowerRoot().getIndividualTemplates()) {
            if (vid.getGenome().getPrimary() != flowerSpecies) continue;
            if (tot > 0 && tot % 3 == 0) {
                x -= 54;
                y += 18;
            }
            ItemStack stack = BotanyCore.getFlowerRoot().getMemberStack(vid, EnumFlowerStage.FLOWER);
            ControlItemDisplay display = new ControlItemDisplay(contents, x, y);
            display.setItemStack(stack);
            ++tot;
            x += 18;
        }
        int numOfLines = 1 + (tot - 1) / 3;
        new ControlText(contents, new Area(0, y - (numOfLines - 1) * 18, w2, 4 + 18 * numOfLines), I18N.localise("botany.gui.database.tab.genome.varieties"), TextJustification.MIDDLE_RIGHT);
        contents.setSize(new Point(contents.getSize().xPos(), y += th));
        scrollable.setScrollableContent(contents);
    }
}

