/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items;

import binnie.core.Mods;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.ItemProduct;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.items.types.IEBEnumItem;
import forestry.api.apiculture.BeeManager;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.core.items.IColoredItem;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoneyComb
extends ItemProduct<EnumHoneyComb>
implements IColoredItem {
    private static final float RESEARCH_SUITABILITY = 0.4f;
    private static final String BOTANY_UID = "rootFlowers";

    private void setResearchSuitability(@Nullable ISpeciesRoot speciesRoot) {
        if (speciesRoot != null) {
            speciesRoot.setResearchSuitability(new ItemStack((Item)this, 1, Short.MAX_VALUE), 0.4f);
        }
    }

    public ItemHoneyComb() {
        super((IEBEnumItem[])EnumHoneyComb.values());
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77655_b("honey_comb");
        this.setRegistryName("honey_comb");
        BeeManager.beeRoot.setResearchSuitability(new ItemStack((Item)this, 1, Short.MAX_VALUE), 0.4f);
        this.setResearchSuitability((ISpeciesRoot)TreeManager.treeRoot);
        this.setResearchSuitability((ISpeciesRoot)ButterflyManager.butterflyRoot);
        this.setResearchSuitability(AlleleManager.alleleRegistry.getSpeciesRoot(BOTANY_UID));
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        EnumHoneyComb honeyComb = (EnumHoneyComb)this.get(stack);
        return honeyComb.getSpriteColour(tintIndex);
    }

    public static boolean isInvalidComb(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (stack.func_77973_b() != ExtraBees.comb) {
            return false;
        }
        EnumHoneyComb honeyComb = EnumHoneyComb.get(stack);
        return !honeyComb.isActive();
    }

    public static enum VanillaComb {
        HONEY,
        COCOA,
        SIMMERING,
        STRINGY,
        FROZEN,
        DRIPPING,
        SILKY,
        PARCHED,
        MYSTERIOUS,
        IRRADIATED,
        POWDERY,
        REDDENED,
        DARKENED,
        OMEGA,
        WHEATEN,
        MOSSY,
        QUARTZ;


        public ItemStack get() {
            return new ItemStack(Mods.Forestry.item("bee_combs"), 1, this.ordinal());
        }
    }
}

