/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.tile;

import binnie.botany.api.BotanyAPI;
import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.api.gardening.IGardeningManager;
import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.PlantType;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.Flower;
import binnie.botany.modules.ModuleFlowers;
import binnie.botany.modules.ModuleGardening;
import binnie.botany.tile.FlowerRenderInfo;
import binnie.core.BinnieCore;
import com.mojang.authlib.GameProfile;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.EnumPlantType;

public class TileEntityFlower
extends TileEntity
implements IPollinatable,
IButterflyNursery {
    @Nullable
    private IFlower flower = null;
    @Nullable
    private GameProfile owner;
    private int section = 0;
    @Nullable
    private FlowerRenderInfo renderInfo = null;
    @Nullable
    private IButterfly caterpillar;
    private int matureTime = 0;

    public void func_145839_a(NBTTagCompound nbtCompound) {
        if (nbtCompound.func_74764_b("Flower")) {
            this.flower = new Flower(nbtCompound.func_74775_l("Flower"));
            if (this.flower.getAge() == 0) {
                this.flower.setFlowered(false);
            }
        }
        if (nbtCompound.func_74764_b("section")) {
            this.section = nbtCompound.func_74771_c("section");
        }
        if (nbtCompound.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbtCompound.func_74775_l("owner"));
        }
        if (nbtCompound.func_74764_b("CATER") && BinnieCore.isLepidopteryActive()) {
            this.matureTime = nbtCompound.func_74762_e("caterTime");
            this.caterpillar = ButterflyManager.butterflyRoot.getMember(nbtCompound.func_74775_l("cater"));
        }
        this.readRenderInfo(nbtCompound);
        super.func_145839_a(nbtCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtCompound) {
        if (this.flower != null) {
            nbtCompound.func_74782_a("Flower", (NBTBase)this.flower.writeToNBT(new NBTTagCompound()));
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbtCompound.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.caterpillar != null) {
            nbtCompound.func_74768_a("caterTime", this.matureTime);
            NBTTagCompound subcompound = new NBTTagCompound();
            this.caterpillar.writeToNBT(subcompound);
            nbtCompound.func_74782_a("cater", (NBTBase)subcompound);
        }
        nbtCompound.func_74774_a("section", (byte)this.getSection());
        return super.func_189515_b(nbtCompound);
    }

    public void create(ItemStack stack, @Nullable GameProfile owner) {
        IFlower flower = BotanyCore.getFlowerRoot().getMember(stack);
        this.create(flower, owner);
    }

    public void create(IFlower flower, @Nullable GameProfile owner) {
        this.flower = flower;
        if (flower.getAge() == 0) {
            flower.setFlowered(false);
        }
        this.updateRender(true);
        this.owner = owner;
    }

    public EnumPlantType getPlantType() {
        return EnumPlantType.Plains;
    }

    @Nullable
    public IIndividual getPollen() {
        return this.getFlower();
    }

    public boolean canMateWith(IIndividual individual) {
        return this.isBreeding() && individual instanceof IFlower && this.getFlower() != null && this.getFlower().getMate() == null && this.getFlower().hasFlowered() && !this.getFlower().isGeneticEqual(individual);
    }

    public void mateWith(IIndividual individual) {
        IAlleleFlowerSpecies primary2;
        if (this.getFlower() == null || !(individual instanceof IFlower)) {
            return;
        }
        IAlleleFlowerSpecies primary = (IAlleleFlowerSpecies)individual.getGenome().getPrimary();
        if (primary == (primary2 = this.getFlower().getGenome().getPrimary()) || this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            this.getFlower().mate((IFlower)individual);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Nullable
    public IFlower getFlower() {
        if (this.getSection() <= 0) {
            return this.flower;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.getSection()));
        if (tile instanceof TileEntityFlower) {
            return ((TileEntityFlower)tile).getFlower();
        }
        return null;
    }

    public boolean isBreeding() {
        Block roots = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
        return BotanyCore.getGardening().isSoil(roots);
    }

    public void randomUpdate(Random rand) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModuleFlowers.flower) {
            this.func_145843_s();
            return;
        }
        if (this.getSection() > 0) {
            return;
        }
        if (this.flower == null) {
            return;
        }
        if (!this.isBreeding()) {
            return;
        }
        if (this.updateState(rand)) {
            return;
        }
        IGardeningManager gardening = BotanyCore.getGardening();
        EnumSoilType soil = gardening.getSoilType(this.field_145850_b, this.field_174879_c.func_177977_b());
        float chanceDispersal = 0.8f;
        chanceDispersal += 0.2f * (float)this.flower.getGenome().getFertility();
        float chancePollinate = 1.0f;
        chancePollinate += 0.25f * (float)this.flower.getGenome().getFertility();
        float chanceSelfPollinate = 0.2f * (chancePollinate *= 1.0f + (float)soil.ordinal() * 0.5f);
        this.plantOffspring(rand, chanceDispersal *= 1.0f + (float)soil.ordinal() * 0.5f);
        this.mateFlower(rand, chancePollinate, chanceSelfPollinate);
        this.spawnButterflies();
        this.matureCaterpillar();
        this.checkIfDead(false);
        this.updateRender(true);
    }

    private void mateFlower(Random rand, float chancePollinate, float chanceSelfPollinate) {
        if (this.field_145850_b.field_73012_v.nextFloat() < chancePollinate && this.flower.hasFlowered() && !this.flower.isWilted()) {
            for (int tries = 0; tries < 4; ++tries) {
                int z;
                int x = rand.nextInt(5) - 2;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(x, 0, z = rand.nextInt(5) - 2));
                if (!(tile instanceof IPollinatable) || !((IPollinatable)tile).canMateWith((IIndividual)this.getFlower())) continue;
                ((IPollinatable)tile).mateWith((IIndividual)this.getFlower());
            }
        }
        if (this.field_145850_b.field_73012_v.nextFloat() < chanceSelfPollinate && this.flower.hasFlowered() && this.flower.getMate() == null) {
            this.mateWith(this.getFlower());
        }
    }

    private void plantOffspring(Random rand, float chanceDispersal) {
        IFlowerGenome mate;
        if (this.field_145850_b.field_73012_v.nextFloat() < chanceDispersal && this.flower.hasFlowered() && !this.flower.isWilted() && (mate = this.flower.getMate()) != null) {
            boolean dispersed = false;
            for (int tries = 0; tries < 5 && !dispersed; ++tries) {
                IFlower offspring;
                int x = rand.nextInt(3) - 1;
                int z = rand.nextInt(3) - 1;
                Block b2 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, -1, z)).func_177230_c();
                if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177982_a(x, 0, z)) || !BotanyCore.getGardening().isSoil(b2) || (offspring = this.flower.getOffspring(this.field_145850_b, this.field_174879_c)) == null) continue;
                BotanyCore.getFlowerRoot().plant(this.field_145850_b, this.field_174879_c.func_177982_a(x, 0, z), offspring, this.getOwner());
                this.flower.removeMate();
                dispersed = true;
            }
        }
    }

    private boolean updateState(Random rand) {
        float light = this.field_145850_b.func_175699_k(this.field_174879_c);
        if (light < 6.0f) {
            for (int offsetX = -2; offsetX <= 2; ++offsetX) {
                for (int offsetY = -2; offsetY <= 2; ++offsetY) {
                    light -= this.field_145850_b.func_175710_j(this.field_174879_c.func_177982_a(offsetX, 0, offsetY)) ? 0.0f : 0.5f;
                }
            }
        }
        IGardeningManager gardening = BotanyCore.getGardening();
        boolean canTolerate = gardening.canTolerate(this.getFlower(), this.field_145850_b, this.field_174879_c);
        if (rand.nextFloat() < this.getFlower().getGenome().getAgeChance()) {
            if (this.flower.getAge() < 1) {
                if (canTolerate && light > 6.0f) {
                    this.doFlowerAge();
                }
            } else {
                this.doFlowerAge();
            }
        }
        if (canTolerate && this.flower.getAge() > 1 && !this.flower.isWilted() && light > 6.0f) {
            this.flower.setFlowered(true);
        }
        if (!canTolerate && this.flower.isWilted() && rand.nextInt(2 + Math.max(this.flower.getAge(), 2)) == 0) {
            this.kill();
            return true;
        }
        if (light < 2.0f && this.flower.isWilted()) {
            this.kill();
            return true;
        }
        if (!canTolerate || light < 1.0f) {
            this.flower.setWilted(true);
        } else {
            this.flower.setWilted(false);
        }
        return false;
    }

    private void doFlowerAge() {
        this.getFlower().age();
        if (this.getFlower().getAge() == 1) {
            IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
            flowerRoot.onGrowFromSeed(this.field_145850_b, this.field_174879_c);
            if (this.getOwner() != null && this.getFlower() != null) {
                flowerRoot.getBreedingTracker(this.field_145850_b, this.getOwner()).registerBirth(this.getFlower());
            }
        }
    }

    private NBTTagCompound writeRenderInfo(NBTTagCompound tag) {
        if (this.renderInfo != null) {
            NBTTagCompound nbtRenderInfo = new NBTTagCompound();
            this.renderInfo.writeToNBT(nbtRenderInfo);
            tag.func_74782_a("renderinfo", (NBTBase)nbtRenderInfo);
        }
        return tag;
    }

    private void readRenderInfo(NBTTagCompound tag) {
        if (tag.func_74764_b("renderinfo")) {
            NBTTagCompound infotag = tag.func_74775_l("renderinfo");
            FlowerRenderInfo info = new FlowerRenderInfo(infotag);
            this.setRender(info);
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readRenderInfo(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        this.updateRender(true);
        return this.writeRenderInfo(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.renderInfo == null && this.getFlower() != null) {
            this.renderInfo = new FlowerRenderInfo(this.getFlower(), this);
        }
        return this.renderInfo != null ? new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_()) : null;
    }

    public void updateRender(boolean update) {
        TileEntity above;
        if (update && this.getFlower() != null && this.getFlower().getGenome() != null) {
            FlowerRenderInfo newInfo = new FlowerRenderInfo(this.getFlower(), this);
            if (this.renderInfo == null || !newInfo.equals(this.renderInfo)) {
                this.setRender(newInfo);
            }
        }
        if ((above = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileEntityFlower) {
            ((TileEntityFlower)above).updateRender(true);
        }
    }

    public int getSection() {
        return this.section;
    }

    public void setSection(int i) {
        this.section = i;
        if (!this.field_145850_b.field_72995_K) {
            this.updateRender(true);
        }
    }

    public ItemStack getItemStack() {
        IFlower flower = this.getFlower();
        if (flower == null) {
            return ItemStack.field_190927_a;
        }
        return BotanyAPI.flowerRoot.getMemberStack(flower, EnumFlowerStage.getStage(flower));
    }

    @Nullable
    private TileEntityFlower getRoot() {
        if (this.getSection() == 0) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.getSection()));
        return tile instanceof TileEntityFlower ? (TileEntityFlower)tile : null;
    }

    public void onShear() {
        if (this.getRoot() != null) {
            this.getRoot().onShear();
        }
        if (this.getFlower() == null || this.getFlower().getAge() <= 1) {
            return;
        }
        Random rand = new Random();
        IFlower cutting = (IFlower)this.getFlower().copy();
        cutting.setAge(0);
        ItemStack cuttingStack = BotanyCore.getFlowerRoot().getMemberStack(cutting, EnumFlowerStage.SEED);
        float f = 0.7f;
        double xPos = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double yPos = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double zPos = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + xPos, (double)this.field_174879_c.func_177956_o() + yPos, (double)this.field_174879_c.func_177952_p() + zPos, cuttingStack);
        entityItem.func_174867_a(10);
        this.field_145850_b.func_72838_d((Entity)entityItem);
        int maxAge = this.getFlower().getMaxAge();
        for (int i = 0; i < maxAge; ++i) {
            if (!rand.nextBoolean()) continue;
            this.getFlower().age();
            if (!this.checkIfDead(true)) continue;
            return;
        }
    }

    public boolean checkIfDead(boolean wasCut) {
        if (this.getSection() != 0) {
            return this.getRoot().checkIfDead(wasCut);
        }
        EnumSoilType soil = BotanyCore.getGardening().getSoilType(this.field_145850_b, this.field_174879_c);
        int maxAge = (int)((float)this.flower.getMaxAge() * (1.0f + (float)soil.ordinal() * 0.25f));
        if (this.flower.getAge() > maxAge) {
            if (!wasCut && this.flower.getMate() != null) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
                IFlower offspring = this.flower.getOffspring(this.field_145850_b, this.field_174879_c.func_177977_b());
                TileEntity above = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
                if (above instanceof TileEntityFlower) {
                    this.field_145850_b.func_175698_g(this.field_174879_c.func_177984_a());
                }
                BotanyCore.getFlowerRoot().plant(this.field_145850_b, this.field_174879_c, offspring, this.getOwner());
            } else {
                this.kill();
            }
            return true;
        }
        return false;
    }

    public void kill() {
        if (this.flower.getAge() > 0) {
            this.field_145850_b.func_180501_a(this.field_174879_c, ModuleGardening.plant.func_176203_a(PlantType.DEAD_FLOWER.ordinal()), 2);
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        int i = 1;
        while (this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i)) instanceof TileEntityFlower) {
            this.field_145850_b.func_175698_g(this.field_174879_c.func_177981_b(i));
            ++i;
        }
    }

    public boolean onBonemeal() {
        if (this.getFlower() == null) {
            return false;
        }
        if (!this.isBreeding()) {
            return false;
        }
        if (this.getFlower().isWilted()) {
            return false;
        }
        if (this.getFlower().getAge() > 1 && !this.getFlower().hasFlowered()) {
            this.getFlower().setFlowered(true);
        }
        this.checkIfDead(false);
        this.updateRender(true);
        return true;
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile ownerName) {
        this.owner = ownerName;
    }

    public void spawnButterflies() {
    }

    private void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        if (BinnieCore.isLepidopteryActive()) {
            ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z);
        }
    }

    public GameProfile getOwnerName() {
        return this.getOwner();
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue((float)this.field_145850_b.func_180494_b(this.func_174877_v()).func_185353_n());
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.field_145850_b.func_180494_b(this.func_174877_v()).func_76727_i());
    }

    @Nullable
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    public void setCaterpillar(@Nullable IButterfly butterfly) {
        this.caterpillar = butterfly;
        this.matureTime = 0;
    }

    public IIndividual getNanny() {
        return this.getFlower();
    }

    public boolean canNurse(IButterfly butterfly) {
        return this.getFlower() != null && !this.getFlower().isWilted() && this.getFlower().getAge() > 1;
    }

    private void matureCaterpillar() {
    }

    public void setRender(FlowerRenderInfo render) {
        this.renderInfo = render;
        this.section = this.renderInfo.getSection();
        if (!this.field_145850_b.field_72995_K) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
        } else {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public int getAge() {
        return this.renderInfo == null ? 1 : (int)this.renderInfo.getAge();
    }

    public int getRenderSection() {
        return this.renderInfo == null ? 1 : (int)this.renderInfo.getSection();
    }

    public boolean isWilted() {
        return this.renderInfo != null && this.renderInfo.isWilted();
    }

    public boolean isFlowered() {
        return this.renderInfo == null || this.renderInfo.isFlowered();
    }

    public int getPrimaryColour() {
        return this.renderInfo == null ? EnumFlowerColor.Red.getFlowerColorAllele().getColor(false) : this.renderInfo.getPrimary().getColor(this.isWilted());
    }

    public int getSecondaryColour() {
        return this.renderInfo == null ? EnumFlowerColor.Red.getFlowerColorAllele().getColor(false) : this.renderInfo.getSecondary().getColor(this.isWilted());
    }

    public int getStemColour() {
        return this.renderInfo == null ? EnumFlowerColor.Green.getFlowerColorAllele().getColor(false) : this.renderInfo.getStem().getColor(this.isWilted());
    }

    public IFlowerType getType() {
        return this.renderInfo == null ? EnumFlowerType.POPPY : this.renderInfo.getType();
    }

    public Biome getBiome() {
        return this.func_145831_w().func_180494_b(this.func_174877_v());
    }

    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public boolean isPollinated() {
        return this.isBreeding();
    }

    public World getWorldObj() {
        return this.field_145850_b;
    }
}

