/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;
import forestry.api.world.ITreeGenData;

public class WorldGenSpruce {

    public static class BlackSpruce
    extends WorldGenTree {
        public BlackSpruce(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.2f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = (float)Math.sqrt(radius);
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class WhiteSpruce
    extends WorldGenTree {
        public WhiteSpruce(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.2f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = (float)Math.sqrt(radius);
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class AlpineSpruce
    extends WorldGenTree {
        public AlpineSpruce(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 5;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            leafSpawn -= 2.0f;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius *= radius;
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f3 = 0.0f;
            float h3 = leafSpawn;
            leafSpawn = h3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(5, 3);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class GiantSpruce
    extends WorldGenTree {
        public GiantSpruce(ITree tree) {
            super((ITreeGenData)tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 3;
            float bottom = this.randBetween(3, 4);
            float width = (float)this.height / this.randBetween(2.5f, 3.0f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = 0.15f + 0.85f * radius;
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f3 = 0.0f;
            float h3 = leafSpawn;
            leafSpawn = h3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(15, 4);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }
}

