/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.recipes;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

class RotatedOreIngredient
extends Ingredient {
    private final NonNullList<ItemStack> ores;
    private final int offset;
    @Nullable
    private IntList itemIds;
    @Nullable
    private ItemStack[] array;

    public RotatedOreIngredient(String ore, int offset) {
        super(0);
        this.ores = OreDictionary.getOres((String)ore);
        this.offset = offset;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.array == null || this.array.length != this.ores.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    continue;
                }
                lst.add((Object)itemstack);
            }
            Collections.rotate(lst, this.offset);
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
        }
        return this.array;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IntList func_194139_b() {
        if (this.itemIds == null || this.itemIds.size() != this.ores.size()) {
            this.itemIds = new IntArrayList(this.ores.size());
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList lst = NonNullList.func_191196_a();
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    for (ItemStack item : lst) {
                        this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)item));
                    }
                    continue;
                }
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack target : this.ores) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
    }
}

