/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.extrabees.utils.config.ConfigurationMain;
import binnie.extrabees.worldgen.WorldGenHive;
import binnie.extrabees.worldgen.WorldGenHiveMarble;
import binnie.extrabees.worldgen.WorldGenHiveNether;
import binnie.extrabees.worldgen.WorldGenHiveRock;
import binnie.extrabees.worldgen.WorldGenHiveWater;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ExtraBeesWorldGenerator
implements IWorldGenerator {
    private final LinkedList<WorldGenHive> worldGenHives = new LinkedList();

    public void registerHiveWorldGen(WorldGenHive hive) {
        this.worldGenHives.add(hive);
    }

    public void doInit() {
        this.registerHiveWorldGen(new WorldGenHiveWater(ConfigurationMain.getWaterHiveRate()));
        this.registerHiveWorldGen(new WorldGenHiveRock(ConfigurationMain.getRockHiveRate()));
        this.registerHiveWorldGen(new WorldGenHiveNether(ConfigurationMain.getNetherHiveRate()));
        this.registerHiveWorldGen(new WorldGenHiveMarble(ConfigurationMain.getMarbleHiveRate()));
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.worldGenHives.forEach(hive -> this.generateHive((WorldGenHive)((Object)hive), rand, chunkX, chunkZ, world));
    }

    private void generateHive(WorldGenHive hive, Random rand, int chunkX, int chunkZ, World world) {
        chunkX <<= 4;
        chunkZ <<= 4;
        for (int i = 0; i < hive.getRate(); ++i) {
            int randPosX = chunkX + rand.nextInt(16);
            int randPosY = rand.nextInt(50) + 20;
            int randPosZ = chunkZ + rand.nextInt(16);
            hive.func_180709_b(world, rand, new BlockPos(randPosX, randPosY, randPosZ));
        }
    }
}

