/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.Binnie;
import binnie.core.api.genetics.IFieldKitPlugin;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.ForestryAllele;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.textures.StandardTexture;
import binnie.core.texture.BinnieCoreTexture;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.Genetics;
import binnie.genetics.api.ITreeBreedingSystem;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TreeBreedingSystem
extends BreedingSystem
implements ITreeBreedingSystem {
    private final UniqueItemStackSet allFruits = new UniqueItemStackSet();
    private final UniqueItemStackSet allWoods = new UniqueItemStackSet();
    private final UniqueItemStackSet discoveredPlanks;
    private final UniqueItemStackSet discoveredFruits = new UniqueItemStackSet();
    private final UniqueItemStackSet discoveredWoods = new UniqueItemStackSet();

    public TreeBreedingSystem() {
        this.discoveredPlanks = new UniqueItemStackSet();
        this.iconUndiscovered = Binnie.RESOURCE.getItemSprite(Genetics.instance, "icon/undiscovered_tree");
        this.iconDiscovered = Binnie.RESOURCE.getItemSprite(Genetics.instance, "icon/discovered_tree");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAlleleSpecies firstSpecies, IAlleleSpecies secondSpecies) {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        ITreeGenome genome0 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(firstSpecies));
        ITreeGenome genome2 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(secondSpecies));
        return ((ITreeMutation)mutation).getChance(player.field_70170_p, player.func_180425_c(), (IAlleleTreeSpecies)firstSpecies, (IAlleleTreeSpecies)secondSpecies, genome0, genome2);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public int getColour() {
        return 53006;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IArboristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumTreeChromosome.GIRTH) {
            return ((IAlleleInteger)allele).getValue() + "x" + ((IAlleleInteger)allele).getValue();
        }
        if (chromosome == EnumTreeChromosome.FRUITS && allele.getUID().contains(".")) {
            IFruitProvider provider = ((IAlleleFruit)allele).getProvider();
            return provider.getProducts().size() == 0 ? I18N.localise("binniecore.allele.none") : ((ItemStack)provider.getProducts().keySet().iterator().next()).func_82833_r();
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public void onSyncBreedingTracker(IBreedingTracker tracker) {
        this.discoveredFruits.clear();
        this.discoveredWoods.clear();
        for (IAlleleSpecies species : this.getDiscoveredSpecies(tracker)) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack wood = treeSpecies.getWoodProvider().getWoodStack();
            if (!wood.func_190926_b()) {
                this.discoveredWoods.add(wood);
            }
            this.discoveredFruits.addAll(genome.getFruitProvider().getProducts().keySet());
            for (ItemStack itemStack : this.discoveredWoods) {
            }
        }
    }

    @Override
    public final void calculateArrays() {
        super.calculateArrays();
        for (IAlleleSpecies species : this.allActiveSpecies) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack wood = treeSpecies.getWoodProvider().getWoodStack();
            if (!wood.func_190926_b()) {
                this.allWoods.add(wood);
            }
            this.allFruits.addAll(genome.getFruitProvider().getProducts().keySet());
        }
    }

    @Override
    public Collection<IAlleleSpecies> getTreesThatBearFruit(ItemStack fruit, boolean master, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = master ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts().keySet()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                found.add(species);
            }
        }
        return found;
    }

    @Override
    public Collection<IAlleleSpecies> getTreesThatCanBearFruit(ItemStack fruit, boolean master, World world, GameProfile player) {
        IAlleleTreeSpecies tSpecies;
        Collection<IAlleleSpecies> set = master ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        HashSet<IFruitFamily> providers = new HashSet<IFruitFamily>();
        for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate((IAlleleSpecies)tSpecies));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts().keySet()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                providers.add(genome.getFruitProvider().getFamily());
            }
        }
        block2: for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            for (IFruitFamily family : providers) {
                if (!tSpecies.getSuitableFruit().contains(family)) continue;
                found.add(species);
                continue block2;
            }
        }
        return found;
    }

    @Override
    public Collection<IAlleleSpecies> getTreesThatHaveWood(ItemStack wood, boolean master, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = master ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack woodStack = treeSpecies.getWoodProvider().getWoodStack();
            if (!woodStack.func_77969_a(wood)) continue;
            found.add(species);
        }
        return found;
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        ISpeciesType type = this.getSpeciesRoot().getType(member);
        return this.isDNAManipulable(type);
    }

    @Override
    public boolean isDNAManipulable(@Nullable ISpeciesType type) {
        return type == EnumGermlingType.POLLEN;
    }

    @Override
    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        return TreeManager.treeRoot.getMember(stack);
    }

    @Override
    public ISpeciesType[] getActiveTypes() {
        return new ISpeciesType[]{EnumGermlingType.SAPLING, EnumGermlingType.POLLEN};
    }

    @Override
    public void addExtraAlleles(IChromosomeType chromosome, TreeSet<IAllele> alleles) {
        switch ((EnumTreeChromosome)chromosome) {
            case FERTILITY: {
                for (ForestryAllele.Saplings a : ForestryAllele.Saplings.values()) {
                    alleles.add(a.getAllele());
                }
                break;
            }
            case GIRTH: {
                for (ForestryAllele.Int a2 : ForestryAllele.Int.values()) {
                    alleles.add(a2.getAllele());
                }
                break;
            }
            case HEIGHT: {
                for (ForestryAllele.TreeHeight a3 : ForestryAllele.TreeHeight.values()) {
                    alleles.add(a3.getAllele());
                }
                break;
            }
            case MATURATION: {
                for (ForestryAllele.Maturation a4 : ForestryAllele.Maturation.values()) {
                    alleles.add(a4.getAllele());
                }
                break;
            }
            case SAPPINESS: {
                for (ForestryAllele.Sappiness a5 : ForestryAllele.Sappiness.values()) {
                    alleles.add(a5.getAllele());
                }
                break;
            }
            case YIELD: {
                for (ForestryAllele.Yield a7 : ForestryAllele.Yield.values()) {
                    alleles.add(a7.getAllele());
                }
                break;
            }
            case FIREPROOF: {
                for (ForestryAllele.Bool a8 : ForestryAllele.Bool.values()) {
                    alleles.add(a8.getAllele());
                }
                break;
            }
        }
    }

    @Override
    public IFieldKitPlugin getFieldKitPlugin() {
        return new FieldKitPlugin();
    }

    @Override
    public Set<ItemStack> getAllFruits() {
        return this.allFruits;
    }

    @Override
    public Set<ItemStack> getAllWoods() {
        return this.allWoods;
    }

    private static class FieldKitPlugin
    implements IFieldKitPlugin {
        private FieldKitPlugin() {
        }

        @Override
        public Map<IChromosomeType, IPoint> getChromosomePickerPositions() {
            HashMap<IChromosomeType, IPoint> positions = new HashMap<IChromosomeType, IPoint>();
            positions.put((IChromosomeType)EnumTreeChromosome.SPECIES, new Point(48, 48));
            positions.put((IChromosomeType)EnumTreeChromosome.HEIGHT, new Point(43, 84));
            positions.put((IChromosomeType)EnumTreeChromosome.FERTILITY, new Point(25, 63));
            positions.put((IChromosomeType)EnumTreeChromosome.FRUITS, new Point(72, 57));
            positions.put((IChromosomeType)EnumTreeChromosome.YIELD, new Point(21, 43));
            positions.put((IChromosomeType)EnumTreeChromosome.SAPPINESS, new Point(15, 17));
            positions.put((IChromosomeType)EnumTreeChromosome.EFFECT, new Point(67, 15));
            positions.put((IChromosomeType)EnumTreeChromosome.MATURATION, new Point(70, 34));
            positions.put((IChromosomeType)EnumTreeChromosome.GIRTH, new Point(45, 67));
            positions.put((IChromosomeType)EnumTreeChromosome.FIREPROOF, new Point(5, 70));
            return positions;
        }

        @Override
        public ITexture getTypeTexture() {
            return new StandardTexture(96, 0, 96, 96, BinnieCoreTexture.GUI_BREEDING);
        }
    }
}

