/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AlvearyLogic;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.client.gui.AlvearyContainer;
import binnie.extrabees.client.gui.ContainerFrameHousing;
import binnie.extrabees.client.gui.GuiContainerAlvearyPart;
import binnie.extrabees.utils.Utils;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AlvearyLogicFrameHousing
extends AlvearyLogic {
    private final ItemStackHandler inv;
    private final TileEntityExtraBeesAlvearyPart tile;

    public AlvearyLogicFrameHousing(TileEntityExtraBeesAlvearyPart tile) {
        this.tile = tile;
        this.inv = new HiveFrameItemStackHandler();
    }

    public IItemHandlerModifiable getInventory() {
        return this.inv;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inv.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        return nbt;
    }

    @Override
    public void wearOutEquipment(int amount) {
        IMultiblockLogicAlveary multiblockLogic;
        IAlvearyController alvearyController;
        ItemStack queenStack;
        IBeeRoot beeRoot;
        IBee queen;
        IHiveFrame hiveFrame = this.getHiveFrame();
        if (hiveFrame != null && (queen = (beeRoot = Utils.getBeeRoot()).getMember(queenStack = (alvearyController = (multiblockLogic = (IMultiblockLogicAlveary)this.tile.getMultiblockLogic()).getController()).getBeeInventory().getQueen())) != null) {
            int wear = Math.round((float)(amount * 5) * beeRoot.getBeekeepingMode(this.tile.getWorldObj()).getWearModifier());
            ItemStack frame = this.inv.getStackInSlot(0);
            ItemStack frameUsed = hiveFrame.frameUsed((IBeeHousing)alvearyController, frame, queen, wear);
            this.inv.setStackInSlot(0, frameUsed);
        }
    }

    @Nullable
    private IHiveFrame getHiveFrame() {
        ItemStack stackInSlot = this.inv.getStackInSlot(0);
        if (!stackInSlot.func_190926_b()) {
            return (IHiveFrame)stackInSlot.func_77973_b();
        }
        return null;
    }

    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(@Nonnull IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.getHiveFrame() == null ? 1.0f : this.getHiveFrame().getBeeModifier().getFloweringModifier(genome, currentModifier);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(@Nonnull EntityPlayer player, int data) {
        return new GuiContainerAlvearyPart<AlvearyContainer>(this.getContainer(player, data));
    }

    @Override
    @Nullable
    public AlvearyContainer getContainer(@Nonnull EntityPlayer player, int data) {
        return new ContainerFrameHousing(player, this);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        return null;
    }

    private static class HiveFrameItemStackHandler
    extends ItemStackHandler {
        public HiveFrameItemStackHandler() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof IHiveFrame)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

