/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.IBinnieGUID;
import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.modules.BlankModuleContainer;
import binnie.core.network.BinniePacketHandler;
import binnie.core.proxy.IProxyCore;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.genetics.MothBreedingSystem;
import binnie.extratrees.genetics.gui.analyst.ButterflyAnalystPagePlugin;
import binnie.extratrees.genetics.gui.analyst.TreeAnalystPagePlugin;
import binnie.extratrees.genetics.gui.analyst.TreeProducePlugin;
import binnie.extratrees.gui.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreesErrorCode;
import binnie.extratrees.modules.ModuleWood;
import binnie.extratrees.proxy.Proxy;
import binnie.genetics.api.GeneticsApi;
import binnie.genetics.api.analyst.IAnalystManager;
import forestry.api.lepidopterology.ButterflyManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="extratrees", name="Binnie's Extra Trees", version="2.5.0.136", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:binniecore;after:binniedesign;")
public class ExtraTrees
extends BlankModuleContainer {
    @Mod.Instance(value="extratrees")
    public static ExtraTrees instance;
    @SidedProxy(clientSide="binnie.extratrees.proxy.ProxyClient", serverSide="binnie.extratrees.proxy.ProxyServer")
    public static Proxy proxy;
    public static IBreedingSystem mothBreedingSystem;

    public ExtraTrees() {
        MinecraftForge.EVENT_BUS.register(ModuleWood.class);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        IAnalystManager analystManager;
        this.container.registerConfigHandler(new ConfigurationMain(this.container));
        super.preInit(evt);
        if (ButterflyManager.butterflyRoot != null) {
            mothBreedingSystem = new MothBreedingSystem();
            Binnie.GENETICS.registerBreedingSystem(mothBreedingSystem);
        }
        if ((analystManager = GeneticsApi.analystManager) != null) {
            analystManager.registerAnalystPagePlugin(new TreeAnalystPagePlugin());
            analystManager.registerAnalystPagePlugin(new ButterflyAnalystPagePlugin());
            analystManager.registerProducePlugin(new TreeProducePlugin());
        }
        for (ExtraTreesErrorCode errorCode : ExtraTreesErrorCode.values()) {
            ErrorStateRegistry.registerErrorState(errorCode);
        }
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
    }

    @Override
    protected void registerModules() {
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return ExtraTreesGUID.values();
    }

    @Override
    public Class<?>[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    @Override
    public String getChannel() {
        return "ET";
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getModId() {
        return "extratrees";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return BinnieCore.isExtraTreesActive();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

