/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.sequencer;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;
import binnie.core.resource.BinnieSprite;
import binnie.genetics.machine.sequencer.Sequencer;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SequencerFX
extends MachineComponent
implements IRender.RandomDisplayTick,
IRender.DisplayTick {
    public SequencerFX(IMachine machine) {
        super(machine);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(World world, BlockPos pos, Random rand) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        SequencerParticleRandomTick particle = new SequencerParticleRandomTick(world, pos, rand);
        BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDisplayTick(World world, BlockPos pos, Random rand) {
        int ticks = (int)(world.func_82737_E() % 16L);
        if (ticks == 0 && this.getUtil().getProcess().isInProgress()) {
            SequencerParticle particle = new SequencerParticle(world, pos);
            BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class SequencerParticle
    extends Particle {
        private static final BinnieSprite[] SPRITES = new BinnieSprite[]{Sequencer.fxSeqA, Sequencer.fxSeqG, Sequencer.fxSeqC, Sequencer.fxSeqT};

        public SequencerParticle(World world, BlockPos pos) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.012;
            this.field_70547_e = 50;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.field_70544_f = 2.0f;
            this.func_187117_a(SPRITES[this.field_187136_p.nextInt(4)].getSprite());
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.field_187130_j = 0.012;
            if (this.field_70546_d > 40) {
                this.func_82338_g((float)(50 - this.field_70546_d) / 10.0f);
            }
        }

        public int func_70537_b() {
            return 1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class SequencerParticleRandomTick
    extends Particle {
        private double axisX;
        private double axisZ;
        private double angle;

        public SequencerParticleRandomTick(World world, BlockPos pos, Random rand) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2 + rand.nextDouble() * 0.2, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.axisX = this.field_187126_f;
            this.axisZ = this.field_187128_h;
            this.angle = this.field_187136_p.nextDouble() * 2.0 * 3.1415;
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.0;
            this.field_70547_e = 200;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.func_70538_b(0.6f + this.field_187136_p.nextFloat() * 0.2f, 1.0f, 0.8f * this.field_187136_p.nextFloat() * 0.2f);
            this.func_189213_a();
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.angle += 0.03;
            this.func_187109_b(this.axisX + 0.4 * Math.sin(this.angle), this.field_187127_g, this.axisZ + 0.4 * Math.cos(this.angle));
            this.field_187130_j = 0.0;
            this.func_82338_g((float)Math.sin(3.14 * (double)this.field_70546_d / (double)this.field_70547_e));
        }

        public int func_70537_b() {
            return 0;
        }
    }
}

