/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.items;

import binnie.core.liquid.AlcoholEffect;
import binnie.core.liquid.DrinkManager;
import binnie.core.liquid.IDrinkLiquid;
import binnie.extratrees.alcohol.GlasswareType;
import binnie.extratrees.alcohol.drink.FluidHandlerItemGlassware;
import binnie.extratrees.liquid.Alcohol;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrink
extends ItemFood
implements IItemModelRegister {
    public static final String TYPE_NBT_KEY = "glassware";

    public ItemDrink() {
        super(0, 0.0f, false);
        this.func_77637_a(Tabs.tabArboriculture);
        this.func_77655_b("drink");
        this.setRegistryName("drink");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77848_i();
    }

    public GlasswareType getGlassware(ItemStack container) {
        NBTTagCompound nbt = container.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(TYPE_NBT_KEY)) {
            return GlasswareType.BEER_MUG;
        }
        return GlasswareType.values()[nbt.func_74765_d(TYPE_NBT_KEY)];
    }

    public ItemStack getStack(GlasswareType glass, @Nullable FluidStack fluid, int amount) {
        ItemStack stack = new ItemStack((Item)this, amount);
        this.saveGlassware(glass, stack);
        this.saveFluid(fluid, stack);
        return stack;
    }

    public ItemStack getStack(GlasswareType glass, @Nullable FluidStack fluid) {
        return this.getStack(glass, fluid, 1);
    }

    public void saveGlassware(GlasswareType container, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74777_a(TYPE_NBT_KEY, (short)container.ordinal());
    }

    public void saveFluid(@Nullable FluidStack fluid, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (fluid == null) {
            nbt.func_82580_o("Fluid");
        } else {
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            handler.fill(fluid, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (GlasswareType glasswareType : GlasswareType.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{glasswareType.getModelLocation()});
        }
        manager.registerItemModel(item, stack -> {
            GlasswareType glasswareType = this.getGlassware(stack);
            return glasswareType.getModelLocation();
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemGlassware(stack, this.getGlassware(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (GlasswareType glasswareType : GlasswareType.values()) {
                items.add((Object)this.getStack(glasswareType, null));
            }
            items.add((Object)this.getStack(GlasswareType.WINE, Alcohol.RedWine.get(GlasswareType.WINE.getCapacity())));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        IDrinkLiquid liquid = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        String liquidName = liquid == null ? null : liquid.getName();
        return this.getGlassware(stack).getName(liquidName);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        AlcoholEffect.makeDrunk(player, 2.1f);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (FluidUtil.getFluidContained((ItemStack)itemStack) != null) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 16;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return super.func_77659_a(world, player, hand);
    }
}

