/*
 * Decompiled with CFR 0.152.
 */
package binnie.design;

import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.machines.inventory.ValidatorSprite;
import binnie.design.DesignerManager;
import binnie.design.EnumDesign;
import binnie.design.api.DesignAPI;
import binnie.design.api.IDesignManager;
import binnie.design.gui.DesignErrorCode;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="binniedesign", name="Binnie's Design", version="2.5.0.135", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:binniecore;")
public class Design {
    @Mod.Instance(value="binniedesign")
    public static Design instance;
    @Nullable
    private static ValidatorSprite spritePolish;
    @Nullable
    private static IDesignManager designManager;

    public static IDesignManager getDesignManager() {
        Objects.requireNonNull(designManager);
        return designManager;
    }

    public static ValidatorSprite getSpritePolish() {
        Objects.requireNonNull(spritePolish);
        return spritePolish;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        DesignAPI.manager = designManager = new DesignerManager();
        spritePolish = new ValidatorSprite("binniedesign", "validator/polish.0", "validator/polish.1");
        for (DesignErrorCode errorCode : DesignErrorCode.values()) {
            ErrorStateRegistry.registerErrorState(errorCode);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        IDesignManager designManager = Design.getDesignManager();
        for (EnumDesign design : EnumDesign.values()) {
            designManager.registerDesign(design.ordinal(), design);
        }
    }
}

