/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.ModId;
import binnie.core.util.I18N;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.EnumFacing;

public class MachineSide {
    public static final EnumSet<EnumFacing> TOP_AND_BOTTOM = EnumSet.of(EnumFacing.UP, EnumFacing.DOWN);
    public static final EnumSet<EnumFacing> NONE = EnumSet.noneOf(EnumFacing.class);
    public static final EnumSet<EnumFacing> TOP = EnumSet.of(EnumFacing.UP);
    public static final EnumSet<EnumFacing> BOTTOM = EnumSet.of(EnumFacing.DOWN);
    public static final EnumSet<EnumFacing> SIDES = EnumSet.of(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST);
    private static final List<EnumFacing> ALL = ImmutableList.of((Object)EnumFacing.UP, (Object)EnumFacing.DOWN, (Object)EnumFacing.NORTH, (Object)EnumFacing.SOUTH, (Object)EnumFacing.EAST, (Object)EnumFacing.WEST);

    public static String asString(Collection<EnumFacing> sides) {
        if (sides.containsAll(ALL)) {
            return I18N.localise(ModId.CORE, "side.any", new Object[0]);
        }
        if (sides.isEmpty()) {
            return I18N.localise(ModId.CORE, "side.none", new Object[0]);
        }
        if (sides.containsAll(SIDES) && SIDES.containsAll(sides)) {
            return I18N.localise(ModId.CORE, "side.sides", new Object[0]);
        }
        StringBuilder text = new StringBuilder();
        boolean firstSide = true;
        ArrayList<EnumFacing> sortedSides = new ArrayList<EnumFacing>(sides);
        sortedSides.sort(Comparator.comparing(ALL::indexOf));
        for (EnumFacing side : sortedSides) {
            String localized = I18N.localise(ModId.CORE, "side." + side.func_176610_l(), new Object[0]);
            if (firstSide) {
                firstSide = false;
            } else {
                text.append(", ");
            }
            text.append(localized);
        }
        return text.toString();
    }
}

