/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.machines.transfer.TransferResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ComponentInventoryTransfer
extends MachineComponent {
    private final List<Transfer> transfers = new ArrayList<Transfer>();

    public ComponentInventoryTransfer(IMachine machine) {
        super(machine);
    }

    public void addRestock(int[] buffer, int destination, int limit) {
        Restock restock = new Restock(this.getMachine(), buffer, destination, limit);
        this.transfers.add(restock);
    }

    public void addRestock(int[] buffer, int destination) {
        Restock restock = new Restock(this.getMachine(), buffer, destination);
        this.transfers.add(restock);
    }

    public void addStorage(int source, int[] destination) {
        Storage storage = new Storage(this.getMachine(), source, destination);
        this.transfers.add(storage);
    }

    @Override
    public void onUpdate() {
        for (Transfer transfer : this.transfers) {
            transfer.transfer(this.getMachine().getInterface(IInventoryMachine.class));
        }
    }

    public void addStorage(int source, int[] destination, Condition condition) {
        Storage storage = new Storage(this.getMachine(), source, destination);
        Transfer transfer = storage.setCondition(condition);
        this.transfers.add(transfer);
    }

    private class Storage
    extends Transfer {
        private final int source;
        private final int[] destination;

        private Storage(IMachine machine, int source, int[] destination) {
            super(machine);
            this.source = source;
            this.destination = destination;
        }

        @Override
        protected void doTransfer(IInventory inv) {
            NonNullList<ItemStack> results;
            TransferRequest transferRequest;
            TransferResult transferResult;
            ItemStack stackInSlot = inv.func_70301_a(this.source);
            if (!stackInSlot.func_190926_b() && (transferResult = (transferRequest = new TransferRequest(stackInSlot, inv).setTargetSlots(this.destination).ignoreValidation()).transfer(null, true)).isSuccess() && (results = transferResult.getRemaining()).size() == 1) {
                inv.func_70299_a(this.source, (ItemStack)results.get(0));
            }
        }

        @Override
        protected boolean fulfilled(IInventory inv) {
            ItemStack stack = inv.func_70301_a(this.source);
            return !stack.func_190926_b() && (this.condition == null || this.condition.fulfilled(stack));
        }
    }

    private class Restock
    extends Transfer {
        private final int[] buffer;
        private final int destination;
        private final int limit;

        private Restock(IMachine machine, int[] buffer, int destination, int limit) {
            super(machine);
            this.buffer = buffer;
            this.destination = destination;
            this.limit = limit;
        }

        private Restock(IMachine machine, int[] buffer, int destination) {
            this(machine, buffer, destination, 64);
        }

        @Override
        protected void doTransfer(IInventory inv) {
            if (inv.func_70301_a(this.destination).func_190926_b()) {
                for (int i : this.buffer) {
                    ItemStack newStack;
                    if (inv.func_70301_a(i).func_190926_b() || (newStack = inv.func_70298_a(i, this.limit)).func_190926_b()) continue;
                    inv.func_70299_a(this.destination, newStack);
                    return;
                }
            }
        }
    }

    public static abstract class Transfer {
        protected final IMachine machine;
        @Nullable
        protected Condition condition;

        private Transfer(IMachine machine) {
            this.machine = machine;
        }

        public final void transfer(IInventory inv) {
            if (this.condition == null || this.fulfilled(inv)) {
                this.doTransfer(inv);
            }
        }

        protected boolean fulfilled(IInventory inv) {
            return true;
        }

        protected void doTransfer(IInventory inv) {
        }

        public final Transfer setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final IMachine getMachine() {
            return this.machine;
        }
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean fulfilled(ItemStack var1);
    }
}

