/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.database.ControlBreedingProgress;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import net.minecraft.util.text.TextFormatting;

public class PageBreeder
extends ControlPage<DatabaseTab> {
    private final GameProfile player;

    public PageBreeder(IWidget parent, GameProfile player, DatabaseTab tab) {
        super(parent, 0, 0, parent.getSize().xPos(), parent.getSize().yPos(), tab);
        this.player = player;
        this.onPageRefresh();
    }

    public void onPageRefresh() {
        this.deleteAllChildren();
        IBreedingSystem system = ((WindowAbstractDatabase)Window.get(this)).getBreedingSystem();
        new ControlTextCentered((IWidget)this, 8, TextFormatting.UNDERLINE + system.getDescriptor() + " " + I18N.localise("binniecore.gui.database.breeder.profile"));
        new ControlTextCentered((IWidget)this, 75, "" + system.getDiscoveredSpeciesCount() + "/" + system.getTotalSpeciesCount() + " " + I18N.localise("binniecore.gui.database.breeder.species"));
        new ControlBreedingProgress(this, 20, 87, 102, 14, system, system.getDiscoveredSpeciesPercentage());
        new ControlTextCentered((IWidget)this, 115, "" + system.getDiscoveredBranchCount() + "/" + system.getTotalBranchCount() + " " + I18N.localise("binniecore.gui.database.breeder.branches"));
        new ControlBreedingProgress(this, 20, 127, 102, 14, system, system.getDiscoveredBranchPercentage());
        if (system.getDiscoveredSecretCount() > 0) {
            new ControlTextCentered((IWidget)this, 155, "" + system.getDiscoveredSecretCount() + "/" + system.getTotalSecretCount() + " " + I18N.localise("binniecore.gui.database.breeder.species.secret"));
        }
        new ControlTextCentered((IWidget)this, 32, this.player.getName());
        new ControlTextCentered((IWidget)this, 44, TextFormatting.ITALIC + system.getEpitome());
    }
}

