/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.BotanyAPI;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.genetics.FlowerDefinition;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlyzerPlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class FlowerAlyzerPlugin
implements IAlyzerPlugin {
    public static final FlowerAlyzerPlugin INSTANCE = new FlowerAlyzerPlugin();
    public static final int COLUMN_0 = 12;
    public static final int COLUMN_1 = 90;
    public static final int COLUMN_2 = 155;
    private static final EnumFlowerChromosome[] firstPageChromosome = new EnumFlowerChromosome[]{EnumFlowerChromosome.SPECIES, EnumFlowerChromosome.SAPPINESS, EnumFlowerChromosome.TERRITORY, EnumFlowerChromosome.FERTILITY, EnumFlowerChromosome.EFFECT, EnumFlowerChromosome.LIFESPAN};
    private static final EnumFlowerChromosome[] secondPageColorChromosome = new EnumFlowerChromosome[]{EnumFlowerChromosome.PRIMARY, EnumFlowerChromosome.SECONDARY, EnumFlowerChromosome.STEM};
    private static final EnumFlowerChromosome[] secondPageToleranceChromosome = new EnumFlowerChromosome[]{EnumFlowerChromosome.TEMPERATURE_TOLERANCE, EnumFlowerChromosome.HUMIDITY_TOLERANCE, EnumFlowerChromosome.PH_TOLERANCE};
    private int lastTopOffset;
    private final int rowSize = 12;
    private final int margin = 10;
    private int guiLeft;
    private int guiTop;
    private final HashMap<String, ItemStack> iconStacks = new HashMap();

    public FlowerAlyzerPlugin() {
        for (FlowerDefinition def : FlowerDefinition.values()) {
            this.iconStacks.put(def.getSpecies().getUID(), def.getMemberStack(EnumFlowerStage.FLOWER));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawLine(GuiScreen gui, int xOffset, String msg, int color) {
        gui.field_146297_k.field_71466_p.func_78276_b(msg, this.guiLeft + xOffset, this.guiTop + this.lastTopOffset + 10, color);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawChromosome(GuiScreen gui, EnumFlowerChromosome chromosome, IFlower flower) {
        this.drawLine(gui, 12, StringUtils.capitalize((String)chromosome.getName()), 0xEEEEEE);
        this.drawLine(gui, 90, I18N.localise(flower.getGenome().getActiveAllele(chromosome).getUnlocalizedName()), 0xEEEEEE);
        this.drawLine(gui, 155, I18N.localise(flower.getGenome().getInactiveAllele(chromosome).getUnlocalizedName()), 0xEEEEEE);
        this.lastTopOffset += 12;
    }

    public void newLine() {
        this.lastTopOffset += 12;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage1(GuiScreen gui, ItemStack itemStack) {
        this.lastTopOffset = 10;
        this.guiLeft = (gui.field_146294_l - 246) / 2;
        this.guiTop = (gui.field_146295_m - 238) / 2;
        IFlower flower = BotanyAPI.flowerRoot.getMember(itemStack);
        if (flower == null) {
            return;
        }
        ItemStack renderP = this.getIconStacks().get(flower.getGenome().getPrimary().getUID());
        ItemStack renderS = this.getIconStacks().get(flower.getGenome().getSecondary().getUID());
        gui.field_146297_k.field_71466_p.func_78276_b("Active", this.guiLeft + 10 + 90, this.guiTop + 10, 0xFFFFFF);
        gui.field_146297_k.field_71466_p.func_78276_b("Inactive", this.guiLeft + 10 + 155, this.guiTop + 10, 0xFFFFFF);
        if (renderP != null && renderS != null) {
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_180450_b(renderP, this.guiLeft + 10 + 90, this.guiTop + 10 + 12);
            itemRender.func_180453_a(gui.field_146297_k.field_71466_p, renderP, this.guiLeft + 10 + 90, this.guiTop + 10 + 12, null);
            itemRender.func_180450_b(renderS, this.guiLeft + 10 + 155, this.guiTop + 10 + 12);
            itemRender.func_180453_a(gui.field_146297_k.field_71466_p, renderS, this.guiLeft + 10 + 90, this.guiTop + 10 + 12, null);
        }
        this.guiTop += 36;
        for (EnumFlowerChromosome chromosom : firstPageChromosome) {
            this.drawChromosome(gui, chromosom, flower);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage2(GuiScreen gui, ItemStack itemStack) {
        this.lastTopOffset = 0;
        this.guiLeft = (gui.field_146294_l - 246) / 2;
        this.guiTop = (gui.field_146295_m - 238) / 2;
        IFlower f = BotanyAPI.flowerRoot.getMember(itemStack);
        for (EnumFlowerChromosome chromosome : secondPageColorChromosome) {
            this.drawChromosome(gui, chromosome, f);
            RenderUtil.drawSolidRect(new Area(this.guiLeft + 90, this.guiTop + this.lastTopOffset + 10, 50, 10), ((IAlleleInteger)f.getGenome().getActiveAllele(chromosome)).getValue());
            RenderUtil.drawSolidRect(new Area(this.guiLeft + 155, this.guiTop + this.lastTopOffset + 10, 50, 10), ((IAlleleInteger)f.getGenome().getInactiveAllele(chromosome)).getValue());
            this.newLine();
        }
        for (EnumFlowerChromosome chromosome : secondPageToleranceChromosome) {
            this.drawChromosome(gui, chromosome, f);
            this.newLine();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage3(GuiScreen gui, ItemStack itemStack) {
    }

    public Map<String, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    public List<String> getHints() {
        return Collections.EMPTY_LIST;
    }
}

