/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.utils;

import binnie.extrabees.utils.EnumBeeBooleanModifier;
import binnie.extrabees.utils.EnumBeeModifier;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BeeModifierLogic {
    private final Map<EnumBeeModifier, Float[]> modifiers = new HashMap<EnumBeeModifier, Float[]>();
    private final List<EnumBeeBooleanModifier> booleanModifiers = new ArrayList<EnumBeeBooleanModifier>();

    public float getModifier(EnumBeeModifier modifier, float currentModifier) {
        if (!this.modifiers.containsKey((Object)modifier)) {
            return 1.0f;
        }
        float mult = this.modifiers.get((Object)modifier)[0].floatValue();
        float limit = this.modifiers.get((Object)modifier)[1].floatValue();
        if (limit >= 1.0f) {
            if (limit <= currentModifier) {
                return 1.0f;
            }
            return Math.min(limit / currentModifier, mult);
        }
        if (limit >= currentModifier) {
            return 1.0f;
        }
        return Math.max(limit / currentModifier, mult);
    }

    public boolean getModifier(EnumBeeBooleanModifier modifier) {
        return this.booleanModifiers.contains((Object)modifier);
    }

    public void setModifier(EnumBeeBooleanModifier modifier) {
        this.booleanModifiers.add(modifier);
    }

    public void setModifier(EnumBeeModifier modifier, float mult, float max) {
        this.modifiers.put(modifier, new Float[]{Float.valueOf(mult), Float.valueOf(max)});
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag flagIn) {
        for (Map.Entry<EnumBeeModifier, Float[]> modifier : this.modifiers.entrySet()) {
            EnumBeeModifier key = modifier.getKey();
            Float[] value = modifier.getValue();
            String modifierName = Translator.translateToLocal((String)key.getName());
            Float multiplier = value[0];
            Float limit = value[1];
            if ((double)multiplier.floatValue() < 0.01) {
                multiplier = Float.valueOf(0.0f);
            }
            if ((double)limit.floatValue() < 0.01) {
                limit = Float.valueOf(0.0f);
            }
            String formatKey = limit.floatValue() >= 1.0f ? "bee.modifier.format.max" : "bee.modifier.format.min";
            String valueString = Translator.translateToLocalFormatted((String)formatKey, (Object[])new Object[]{multiplier, limit});
            tooltip.add(modifierName + ": " + valueString);
        }
    }
}

