/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AlvearyLogicElectrical;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import forestry.api.multiblock.IMultiblockComponent;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class AlvearyLogicTransmitter
extends AlvearyLogicElectrical {
    private Set<IEnergyStorage> storages = new HashSet<IEnergyStorage>();

    public AlvearyLogicTransmitter() {
        super(2000);
    }

    @Override
    public void onMachineAssembled(TileEntityExtraBeesAlvearyPart tile) {
        super.onMachineAssembled(tile);
        for (IMultiblockComponent part : tile.getConnectedComponents()) {
            TileEntity tileEntity;
            if (!(part instanceof TileEntity) || part == tile || !(tileEntity = (TileEntity)part).hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) continue;
            this.storages.add((IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP));
        }
    }

    @Override
    public void onMachineBroken(TileEntityExtraBeesAlvearyPart tile) {
        super.onMachineBroken(tile);
        this.storages.clear();
    }

    @Override
    public void updateServer(TileEntityExtraBeesAlvearyPart tile) {
        if (this.energyStorage.getEnergyStored() < 2) {
            return;
        }
        if (this.storages.isEmpty()) {
            return;
        }
        int div = this.storages.size();
        int maxOutput = 500;
        int output = this.energyStorage.getEnergyStored() / div;
        if (output > maxOutput) {
            output = maxOutput;
        }
        if (output < 1) {
            return;
        }
        for (IEnergyStorage handler : this.storages) {
            int recieved = handler.receiveEnergy(output, false);
            this.energyStorage.extractEnergy(recieved, false);
            if (this.energyStorage.getEnergyStored() >= output) continue;
            return;
        }
    }
}

