/*
 * Decompiled with CFR 0.152.
 */
package binnie.design.gui;

import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.EnumErrorType;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.util.I18N;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public enum DesignErrorCode implements IErrorStateDefinition
{
    DESIGNER_NO_ADHESIVE("designer.no.adhesive", CoreErrorCode.NO_ITEM);

    private final String name;
    @Nullable
    private final IErrorStateDefinition parent;
    @Nullable
    private final EnumErrorType type;

    private DesignErrorCode(String name, IErrorStateDefinition parent) {
        this(name, parent, EnumErrorType.NONE);
    }

    private DesignErrorCode(String name, IErrorStateDefinition parent, EnumErrorType type) {
        this.name = name;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public String getUID() {
        return "binniedesign:" + this.name;
    }

    @Override
    public String getDescription() {
        return I18N.localise(new ResourceLocation("binniedesign", "errors." + this.name + ".desc"));
    }

    @Override
    public String getName() {
        if (this.parent != null) {
            return this.parent.getName();
        }
        return I18N.localise(new ResourceLocation("binniedesign", "errors." + this.name + ".name"));
    }

    @Override
    @Nullable
    public EnumErrorType getType() {
        if (this.parent != null) {
            return this.parent.getType();
        }
        return this.type;
    }
}

