/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.punnett;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.renderer.RenderUtil;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.LinkedList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlPunnett
extends Control {
    private static final int BOX_WIDTH = 80;
    private static final int BOX_HEIGHT = 28;

    protected ControlPunnett(IWidget parent, int x, int y) {
        super(parent, x, y, 240, 240);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.drawSolidRect(new Area(0, 28, 240, 1), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(40, 56, Math.round(200.0f), 1), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(80, 0, 1, 84), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(160, 14, 1, Math.round(70.0f)), 0xAAAAAA);
    }

    public void setup(IChromosomeType chromosome, IIndividual ind1, IIndividual ind2, ISpeciesRoot root) {
        this.deleteAllChildren();
        if (chromosome == null || ind1 == null || ind2 == null || root == null) {
            return;
        }
        IAllele primary1 = ind1.getGenome().getActiveAllele(chromosome);
        IAllele primary2 = ind2.getGenome().getActiveAllele(chromosome);
        IAllele secondary1 = ind1.getGenome().getInactiveAllele(chromosome);
        IAllele secondary2 = ind2.getGenome().getInactiveAllele(chromosome);
        int x = 1;
        int y = 1;
        for (IAllele allele1 : new IAllele[]{primary1, secondary1}) {
            y = 1;
            for (IAllele allele2 : new IAllele[]{primary2, secondary2}) {
                LinkedList<IAllele> alleles = new LinkedList<IAllele>();
                if (allele1.isDominant() && !allele2.isDominant()) {
                    alleles.add(allele1);
                } else if (allele2.isDominant() && !allele1.isDominant()) {
                    alleles.add(allele2);
                } else {
                    alleles.add(allele1);
                    if (allele1 != allele2) {
                        alleles.add(allele2);
                    }
                }
                StringBuilder text = new StringBuilder();
                for (IAllele allele3 : alleles) {
                    text.append(allele3.getAlleleName()).append(": ").append(25.0f / (float)alleles.size()).append("%\n");
                }
                new ControlText(this, new Area(x * 80, 28 * y, 80, 28), text.toString(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
                ++y;
            }
            ++x;
        }
        new ControlText(this, new Area(80, 0, 80, 28), "\n" + primary1.getAlleleName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(160, 0, 80, 28), "\n" + secondary1.getAlleleName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(0, 28, 80, 28), primary2.getAlleleName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(0, 56, 80, 28), primary2.getAlleleName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
    }
}

