/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.gui.KeyBindings;
import binnie.core.gui.resource.stylesheet.StyleSheetManager;
import binnie.core.models.ModelManager;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.util.I18N;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class BinnieProxyClient
extends BinnieProxy
implements IBinnieProxy {
    public static final ModelManager modelManager = new ModelManager("binniecore");

    public static ModelManager getModelManager() {
        return modelManager;
    }

    @Override
    public Item registerItem(Item item) {
        BinnieProxyClient.getModelManager().registerItemClient(item);
        return super.registerItem(item);
    }

    @Override
    public Block registerBlock(Block block) {
        BinnieProxyClient.getModelManager().registerBlockClient(block);
        return super.registerBlock(block);
    }

    @Override
    public void registerModels() {
        BinnieProxyClient.getModelManager().registerModels();
    }

    @Override
    public void reloadSprites() {
        ModelManager.reloadSprites();
    }

    @Override
    public void registerItemAndBlockColors() {
        BinnieProxyClient.getModelManager().registerItemAndBlockColors();
    }

    @Override
    public void registerSprite(ResourceLocation location) {
        Minecraft.func_71410_x().func_147117_R().func_174942_a(location);
    }

    @Override
    public void registerModel(Item item, int meta, ModelResourceLocation modelResourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        this.getMinecraftInstance().func_110434_K().func_110577_a(location);
    }

    @Override
    public boolean checkTexture(ResourceLocation location) {
        SimpleTexture texture = new SimpleTexture(location);
        try {
            texture.func_110551_a(this.getMinecraftInstance().func_110442_L());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public World getWorld() {
        return this.getMinecraftInstance().field_71441_e;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public File getDirectory() {
        return new File(".");
    }

    @Override
    public <T extends TileEntity> void registerTileEntity(Class<? extends T> tile, String id, IBinnieProxy.ClientSupplier<TileEntitySpecialRenderer<T>> rendererSupplier) {
        ClientRegistry.registerTileEntity(tile, (String)id, rendererSupplier.get());
    }

    @Override
    public TextureAtlasSprite getTextureAtlasSprite(ResourceLocation location) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void preInit() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            IReloadableResourceManager resourceManager = (IReloadableResourceManager)manager;
            resourceManager.func_110542_a((IResourceManagerReloadListener)new StyleSheetManager());
            resourceManager.func_110542_a(resourceManager1 -> I18N.onResourceReload());
        }
    }

    @Override
    public void init() {
        super.init();
        KeyBindings.init();
    }
}

