/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AbstractAlvearyLogic;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.circuit.StimulatorCircuit;
import binnie.extrabees.client.gui.ContainerStimulator;
import binnie.extrabees.client.gui.GuiContainerStimulator;
import com.google.common.collect.Lists;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AlvearyLogicStimulator
extends AbstractAlvearyLogic {
    private final IEnergyStorage energyStorage;
    private final ItemStackHandler inv;
    private final List<ContainerStimulator> containers = Lists.newArrayList();
    private int powerUsage = 0;
    private boolean powered = false;
    private StimulatorCircuit[] modifiers = new StimulatorCircuit[0];

    public AlvearyLogicStimulator() {
        this.energyStorage = new EnergyStorage(10000);
        this.inv = new ChipsetItemStackHandler();
    }

    public IItemHandlerModifiable getInventory() {
        return this.inv;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, (NBTBase)nbt.func_74775_l("Energy"));
        this.inv.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("Energy", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null));
        nbt.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        return nbt;
    }

    @Override
    public void updateServer(TileEntityExtraBeesAlvearyPart tile) {
        this.modifiers = this.getCircuits();
        this.powerUsage = 0;
        for (StimulatorCircuit beeMod : this.modifiers) {
            this.powerUsage += beeMod.getPowerUsage();
        }
        this.powered = this.energyStorage.extractEnergy(this.powerUsage, true) >= this.powerUsage;
        for (ContainerStimulator c : this.containers) {
            c.checkPower();
        }
    }

    public void onContainerOpened(ContainerStimulator container) {
        this.containers.add(container);
    }

    public void onGuiClosed(ContainerStimulator container) {
        this.containers.remove((Object)container);
    }

    @Nullable
    private ICircuitBoard getHiveFrame() {
        if (!this.inv.getStackInSlot(0).func_190926_b()) {
            return ChipsetManager.circuitRegistry.getCircuitBoard(this.inv.getStackInSlot(0));
        }
        return null;
    }

    public StimulatorCircuit[] getCircuits() {
        ICircuitBoard board = this.getHiveFrame();
        if (board == null) {
            return new StimulatorCircuit[0];
        }
        ICircuit[] circuits = board.getCircuits();
        ArrayList<StimulatorCircuit> mod = new ArrayList<StimulatorCircuit>();
        for (ICircuit circuit : circuits) {
            if (!(circuit instanceof StimulatorCircuit)) continue;
            mod.add((StimulatorCircuit)circuit);
        }
        return mod.toArray(new StimulatorCircuit[0]);
    }

    @Override
    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(@Nonnull IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(@Nonnull IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        if (!this.powered) {
            return mod;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            mod *= beeMod.getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public boolean isSealed() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSealed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSelfLighted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isSunlightSimulated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHellish() {
        if (!this.powered) {
            return false;
        }
        for (StimulatorCircuit beeMod : this.modifiers) {
            if (!beeMod.isHellish()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void wearOutEquipment(int amount) {
        this.energyStorage.extractEnergy(this.powerUsage, false);
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(@Nonnull EntityPlayer player, int data) {
        return new GuiContainerStimulator(this.getContainer(player, data));
    }

    @Override
    @Nonnull
    public ContainerStimulator getContainer(@Nonnull EntityPlayer player, int data) {
        return new ContainerStimulator(player, this);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    private static class ChipsetItemStackHandler
    extends ItemStackHandler {
        public ChipsetItemStackHandler() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!ChipsetManager.circuitRegistry.isChipset(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

