/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.models;

import binnie.botany.Botany;
import binnie.botany.api.genetics.IFlowerType;
import binnie.core.Binnie;
import binnie.core.resource.BinnieSprite;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlowerSpriteManager {
    private static final Map<IFlowerType, FlowerSprites> flowerSprites = new HashMap<IFlowerType, FlowerSprites>();

    public static void initSprites(IFlowerType type) {
        if (flowerSprites.containsKey(type)) {
            return;
        }
        flowerSprites.put(type, new FlowerSprites(type));
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getStem(IFlowerType type, int section, boolean flowered) {
        FlowerSprites flower = flowerSprites.get(type);
        if (flower == null) {
            return null;
        }
        return flower.getStem(type, section, flowered);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getPetal(IFlowerType type, int section, boolean flowered) {
        FlowerSprites flower = flowerSprites.get(type);
        if (flower == null) {
            return null;
        }
        return flower.getPetal(type, section, flowered);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getVariant(IFlowerType type, int section, boolean flowered) {
        FlowerSprites flower = flowerSprites.get(type);
        if (flower == null) {
            return null;
        }
        return flower.getVariant(type, section, flowered);
    }

    private static class FlowerSprites {
        private final BinnieSprite[] stem;
        private final BinnieSprite[] variant;
        private final BinnieSprite[] petal;
        private final BinnieSprite[] unflowered;
        private final int sections;

        public FlowerSprites(IFlowerType type) {
            this.sections = type.getSections();
            this.stem = new BinnieSprite[this.sections];
            this.petal = new BinnieSprite[this.sections];
            this.variant = new BinnieSprite[this.sections];
            this.unflowered = new BinnieSprite[this.sections];
            for (int section = 0; section < this.sections; ++section) {
                String suf = section == 0 ? "" : "" + (section + 1);
                String pre = this.sections == 1 ? "" : "double/";
                this.stem[section] = Binnie.RESOURCE.getBlockSprite(Botany.instance, "flowers/" + pre + type.toString().toLowerCase() + suf + ".0");
                this.petal[section] = Binnie.RESOURCE.getBlockSprite(Botany.instance, "flowers/" + pre + type.toString().toLowerCase() + suf + ".1");
                this.variant[section] = Binnie.RESOURCE.getBlockSprite(Botany.instance, "flowers/" + pre + type.toString().toLowerCase() + suf + ".2");
                this.unflowered[section] = Binnie.RESOURCE.getBlockSprite(Botany.instance, "flowers/" + pre + type.toString().toLowerCase() + suf + ".3");
            }
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getStem(IFlowerType type, int section, boolean flowered) {
            return this.stem[section % this.sections].getSprite();
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getPetal(IFlowerType type, int section, boolean flowered) {
            return (flowered ? this.petal[section % this.sections] : this.unflowered[section % this.sections]).getSprite();
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getVariant(IFlowerType type, int section, boolean flowered) {
            return flowered ? this.variant[section % this.sections].getSprite() : null;
        }
    }
}

