/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AbstractAlvearyLogic;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.client.gui.AbstractAlvearyContainer;
import binnie.extrabees.client.gui.ContainerHatchery;
import binnie.extrabees.client.gui.GuiContainerAlvearyPart;
import binnie.extrabees.utils.Utils;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AlvearyLogicHatchery
extends AbstractAlvearyLogic {
    private final ItemStackHandler inv = new LarvaeItemStackHandler();

    public IItemHandlerModifiable getInventory() {
        return this.inv;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inv.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        return nbt;
    }

    @Override
    public void updateServer(TileEntityExtraBeesAlvearyPart tile) {
        IAlvearyControllerInternal house;
        if (tile.getWorldObj().field_73012_v.nextInt(2400) == 0 && !(house = ((MultiblockLogicAlveary)tile.getMultiblockLogic()).getController()).getErrorLogic().hasErrors()) {
            IBee queen;
            ItemStack queenStack = house.getBeeInventory().getQueen();
            IBeeRoot beeRoot = Utils.getBeeRoot();
            IBee iBee = queen = queenStack.func_190926_b() ? null : beeRoot.getMember(queenStack);
            if (queen != null) {
                ItemStack larvae = beeRoot.getMemberStack((IIndividual)beeRoot.getBee(queen.getGenome()), (ISpeciesType)EnumBeeType.LARVAE);
                for (int i = 0; i < 5; ++i) {
                    if (!this.inv.insertItem(i, larvae, false).func_190926_b()) continue;
                    return;
                }
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(@Nonnull EntityPlayer player, int data) {
        return new GuiContainerAlvearyPart(this.getContainer(player, data));
    }

    @Override
    @Nullable
    public AbstractAlvearyContainer getContainer(@Nonnull EntityPlayer player, int data) {
        return new ContainerHatchery(player, this);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    private static class LarvaeItemStackHandler
    extends ItemStackHandler {
        public LarvaeItemStackHandler() {
            super(5);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && Utils.getBeeRoot().getType(stack) != EnumBeeType.LARVAE) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

