/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenTree2 {

    public static class Clove
    extends WorldGenTree {
        public Clove(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = 2.0f;
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width - 1.0f, 1, this.leaf, false);
            while (leafSpawn > 2.0f) {
                float f2 = 0.0f;
                float h2 = leafSpawn;
                leafSpawn = h2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width - 0.6f, 1, this.leaf, false);
            }
            float f3 = 0.0f;
            float h3 = leafSpawn;
            leafSpawn = h3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), width, 1, this.leaf, false);
            float f4 = 0.0f;
            float h4 = leafSpawn;
            leafSpawn = h4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h4, 0.0f), width - 0.4f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 1);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Box
    extends WorldGenTree {
        public Box(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = 0.0f;
            float width = 1.5f;
            while (leafSpawn > 0.0f) {
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), 1.5f, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(3, 1);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Gingko
    extends WorldGenTree {
        public Gingko(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = 2.0f;
            float width = (float)this.height * this.randBetween(0.55f, 0.6f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width - 2.0f, 1, this.leaf, false);
            while (leafSpawn > 5.0f) {
                float f2 = 0.0f;
                float h2 = leafSpawn;
                leafSpawn = h2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width - 1.5f, 1, this.leaf, false);
                float f3 = 0.0f;
                float h3 = leafSpawn;
                leafSpawn = h3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), width - 0.9f, 1, this.leaf, false);
            }
            float f4 = 0.0f;
            float h4 = leafSpawn;
            leafSpawn = h4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h4, 0.0f), width, 1, this.leaf, false);
            while (leafSpawn > 2.0f) {
                float f5 = 0.0f;
                float h5 = leafSpawn;
                leafSpawn = h5 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h5, 0.0f), width - 0.9f, 1, this.leaf, false);
                float f6 = 0.0f;
                float h6 = leafSpawn;
                leafSpawn = h6 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h6, 0.0f), width, 1, this.leaf, false);
            }
            float f7 = 0.0f;
            float h7 = leafSpawn;
            leafSpawn = h7 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h7, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Iroko
    extends WorldGenTree {
        public Iroko(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.45f, 0.5f);
            if (width < 2.5f) {
                width = 2.5f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width * 0.25f, 1, this.leaf, false);
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width * 0.5f, 1, this.leaf, false);
            float f3 = 0.0f;
            float h3 = leafSpawn;
            leafSpawn = h3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), width * 0.7f, 1, this.leaf, false);
            float f4 = 0.0f;
            float h4 = leafSpawn;
            leafSpawn = h4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h4, 0.0f), width, 1, this.leaf, false);
            float f5 = 0.0f;
            float h5 = leafSpawn;
            leafSpawn = h5 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h5, 0.0f), width - 2.0f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Pear
    extends WorldGenTree {
        public Pear(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width - 1.0f, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = 0.0f;
                float h2 = leafSpawn;
                leafSpawn = h2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width, 1, this.leaf, false);
            }
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(3, 1);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Locust
    extends WorldGenTree {
        public Locust(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = 2.0f;
            float width = (float)this.height * this.randBetween(0.35f, 0.4f);
            if (width < 2.0f) {
                width = 2.0f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width - 1.0f, 1, this.leaf, false);
            while (leafSpawn > 3.0f) {
                float f2 = 0.0f;
                float h2 = leafSpawn;
                leafSpawn = h2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width - 0.3f, 1, this.leaf, false);
                float f3 = 0.0f;
                float h3 = leafSpawn;
                leafSpawn = h3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), width - 0.7f, 1, this.leaf, false);
            }
            float f4 = 0.0f;
            float h4 = leafSpawn;
            leafSpawn = h4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h4, 0.0f), width, 1, this.leaf, false);
            float f5 = 0.0f;
            float h5 = leafSpawn;
            leafSpawn = h5 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h5, 0.0f), width - 0.4f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Sweetgum
    extends WorldGenTree {
        public Sweetgum(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 1;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.7f, 0.75f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius *= 2.0f - radius;
                float f = 0.0f;
                float h = leafSpawn;
                leafSpawn = h - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(5, 1);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }

    public static class Olive
    extends WorldGenTree {
        public Olive(ITreeGenData tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.35f, 0.4f);
            if ((double)width < 1.2) {
                width = 1.55f;
            }
            float f = 0.0f;
            float h = leafSpawn;
            leafSpawn = h - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h, 0.0f), width - 1.0f, 1, this.leaf, false);
            float f2 = 0.0f;
            float h2 = leafSpawn;
            leafSpawn = h2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h2, 0.0f), width, 1, this.leaf, false);
            float f3 = 0.0f;
            float h3 = leafSpawn;
            leafSpawn = h3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, h3, 0.0f), width - 0.5f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 1);
            this.girth = this.determineGirth(this.treeGen.getGirth());
        }
    }
}

