/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.util.ForestryRecipeUtil;
import binnie.genetics.api.analyst.IProducePlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GeneticsProducePlugin
implements IProducePlugin {
    @Override
    public void getFluids(ItemStack inputStack, NonNullList<FluidStack> outputFluids) {
        ForestryRecipeUtil.getSqueezerFluidOutputs(inputStack, outputFluids);
    }

    @Override
    public void getFluids(FluidStack inputFluid, NonNullList<FluidStack> outputFluids) {
    }

    @Override
    public void getItems(ItemStack inputStack, NonNullList<ItemStack> outputItems) {
        ForestryRecipeUtil.getCentrifugeOutputs(inputStack, outputItems);
        ForestryRecipeUtil.getSqueezerOutputs(inputStack, outputItems);
        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
        if (!smeltingResult.func_190926_b()) {
            outputItems.add((Object)smeltingResult);
        }
        GeneticsProducePlugin.getCrafting(inputStack, outputItems);
    }

    private static void getCrafting(ItemStack inputStack, NonNullList<ItemStack> outputItems) {
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_190926_b() || !GeneticsProducePlugin.matches(recipe, inputStack)) continue;
            outputItems.add((Object)recipeOutput);
        }
    }

    private static boolean matches(IRecipe recipe, ItemStack inputStack) {
        NonNullList ingredients = recipe.func_192400_c();
        if (ingredients.isEmpty()) {
            return false;
        }
        for (Ingredient ingredient : ingredients) {
            if (ingredient.apply(inputStack)) continue;
            return false;
        }
        return true;
    }
}

