/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import binnie.core.ModId;
import binnie.core.util.Log;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class I18N {
    @Nullable
    private static NumberFormat percentFormat;
    @Nullable
    private static NumberFormat numberFormat;

    public static void onResourceReload() {
        percentFormat = null;
        numberFormat = null;
    }

    public static NumberFormat getPercentFormat() {
        if (percentFormat == null) {
            percentFormat = DecimalFormat.getPercentInstance(I18N.getLocale());
        }
        return percentFormat;
    }

    public static NumberFormat getNumberFormat() {
        if (numberFormat == null) {
            numberFormat = DecimalFormat.getNumberInstance(I18N.getLocale());
        }
        return numberFormat;
    }

    public static String localiseOrBlank(String key) {
        String trans = I18N.localise(key);
        return trans.equals(key) ? "" : trans;
    }

    public static String localise(String key) {
        if (I18n.func_188566_a((String)key)) {
            return I18n.func_135052_a((String)key, (Object[])new Object[0]);
        }
        return key;
    }

    public static String localise(ModId modId, String path, Object ... format) {
        return I18N.localise(modId.getDomain() + "." + path, format);
    }

    public static String localise(ResourceLocation key) {
        return I18N.localise(key.func_110624_b() + "." + key.func_110623_a());
    }

    public static boolean canLocalise(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static String localise(String key, Object ... format) {
        try {
            return I18n.func_135052_a((String)key, (Object[])format);
        }
        catch (IllegalFormatException e) {
            String errorMessage = "Format error: " + key;
            Log.error(errorMessage, e);
            return errorMessage;
        }
    }

    public static String localise(ResourceLocation key, Object ... format) {
        return I18N.localise(key.func_110624_b() + "." + key.func_110623_a(), format);
    }

    public static Locale getLocale() {
        Language currentLanguage;
        LanguageManager languageManager;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (languageManager = minecraft.func_135016_M()) != null && (currentLanguage = languageManager.func_135041_c()) != null) {
            return currentLanguage.getJavaLocale();
        }
        return Locale.getDefault();
    }
}

