/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.fieldkit;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.events.EventHandlerOrigin;
import binnie.core.genetics.ManagerGenetics;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.fieldkit.ControlChromosome;
import binnie.core.gui.fieldkit.SlotValidatorIndividual;
import binnie.core.gui.fieldkit.SlotValidatorPaper;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.minecraft.control.ControlImage;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.resource.stylesheet.StyleSheetManager;
import binnie.core.gui.resource.textures.StandardTexture;
import binnie.core.texture.BinnieCoreTexture;
import binnie.core.util.I18N;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowFieldKit
extends Window {
    public static final int INDIVIDUAL_SLOT = 0;
    public static final int PAPER_SLOT = 1;
    private float glassOffsetX = 0.0f;
    private float glassOffsetY = 0.0f;
    private float glassVX = 0.0f;
    private float glassVY = 0.0f;
    private final Random glassRand = new Random();
    private Control GlassControl;
    private ControlChromosome chromo;
    private ControlText text;
    private float analyseProgress = 1.0f;
    private boolean isAnalysing = false;
    private final Map<IChromosomeType, String> info = new HashMap<IChromosomeType, String>();

    public WindowFieldKit(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        super(280, 230, player, inventory, side);
    }

    @Override
    protected String getModId() {
        return BinnieCore.getInstance().getModId();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Field Kit";
    }

    private void setupValidators() {
        WindowInventory inventory = this.getWindowInventory();
        inventory.setValidator(0, new SlotValidatorIndividual(null));
        inventory.setValidator(1, new SlotValidatorPaper(null));
        inventory.disableAutoDispense(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(I18N.localise("binniecore.gui.fieldkit.title"));
        CraftGUI.RENDER.setStyleSheet(StyleSheetManager.getSheet("punnett"));
        WindowInventory inventory = this.getWindowInventory();
        inventory.createSlot(0);
        inventory.createSlot(1);
        this.setupValidators();
        new ControlPlayerInventory(this);
        Point handGlass = new Point(16, 32);
        this.GlassControl = new ControlImage(this, handGlass.xPos(), handGlass.yPos(), new StandardTexture(0, 160, 96, 96, BinnieCoreTexture.GUI_PUNNETT));
        new ControlSlot.Builder(this, handGlass.xPos() + 54, handGlass.yPos() + 26).assign(InventoryType.WINDOW, 0);
        new ControlSlot.Builder(this, 208, 8).assign(InventoryType.WINDOW, 1);
        this.text = new ControlText(this, new Point(232, 13), I18N.localise("binniecore.gui.fieldkit.paper"));
        this.text.setColor(0x222222);
        this.text = new ControlText(this, new Area(0, 120, this.getWidth(), 24), "", TextJustification.MIDDLE_CENTER);
        this.text.setColor(0x222222);
        this.chromo = new ControlChromosome(this, 150, 24);
        this.addEventHandler(EventValueChanged.class, EventHandlerOrigin.DIRECT_CHILD, this.chromo, event -> {
            IChromosomeType type = (IChromosomeType)event.getValue();
            if (type != null && this.info.containsKey(type)) {
                String t = this.info.get(type);
                this.text.setValue(t);
            } else {
                this.text.setValue("");
            }
        });
    }

    @Override
    public void initialiseServer() {
        WindowInventory inventory = this.getWindowInventory();
        ItemStack kit = this.getPlayer().func_184614_ca();
        int sheets = 64 - kit.func_77952_i();
        inventory.createSlot(0);
        inventory.createSlot(1);
        if (sheets != 0) {
            inventory.func_70299_a(1, new ItemStack(Items.field_151121_aF, sheets));
        }
        this.setupValidators();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.isAnalysing) {
            this.analyseProgress += 0.01f;
            if (this.analyseProgress >= 1.0f) {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                ItemStack stack = this.getWindowInventory().func_70301_a(0);
                if (!stack.func_190926_b()) {
                    this.sendClientAction("analyse", new NBTTagCompound());
                }
                this.refreshSpecies();
            }
        }
        this.glassVX += this.glassRand.nextFloat() - 2.5f - this.glassOffsetX * 1.0f;
        this.glassVY += this.glassRand.nextFloat() - 2.5f - this.glassOffsetY * 1.0f;
        this.glassOffsetX += this.glassVX;
        this.glassOffsetX *= 1.0f - this.analyseProgress;
        this.glassOffsetY += this.glassVY;
        this.glassOffsetY *= 1.0f - this.analyseProgress;
        this.GlassControl.setOffset(new Point((int)this.glassOffsetX, (int)this.glassOffsetY));
    }

    private void refreshSpecies() {
        ItemStack item = this.getWindowInventory().func_70301_a(0);
        if (item.func_190926_b() || !AlleleManager.alleleRegistry.isIndividual(item)) {
            return;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(item);
        if (ind == null) {
            return;
        }
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(item);
        if (root == null) {
            return;
        }
        IBreedingSystem system = Binnie.GENETICS.getSystem(root);
        this.chromo.setSystem(system);
        Random rand = new Random();
        this.info.clear();
        for (IChromosomeType type : root.getKaryotype()) {
            if (Binnie.GENETICS.isInvalidChromosome(type)) continue;
            IAllele allele = ind.getGenome().getActiveAllele(type);
            ArrayList<String> infos = new ArrayList<String>();
            int i = 0;
            String pref = root.getUID() + ".fieldkit." + type.getName().toLowerCase() + ".";
            while (I18N.canLocalise(pref + i)) {
                infos.add(I18N.localise(pref + i));
                ++i;
            }
            String text = system.getAlleleName(type, allele);
            if (!infos.isEmpty()) {
                text = (String)infos.get(rand.nextInt(infos.size()));
            }
            this.info.put(type, text);
            this.chromo.setSystem(system);
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        super.onWindowInventoryChanged();
        WindowInventory inventory = this.getWindowInventory();
        if (this.isServer()) {
            int size;
            ItemStack kit = this.getPlayer().func_184614_ca();
            if (kit.func_190926_b() || !kit.func_77973_b().equals((Object)BinnieCore.getFieldKit())) {
                return;
            }
            ItemStack paper = inventory.func_70301_a(1);
            int sheets = 64 - kit.func_77952_i();
            int n = size = paper.func_190926_b() ? 0 : paper.func_190916_E();
            if (sheets != size) {
                kit.func_77964_b(64 - size);
            }
            ((EntityPlayerMP)this.getPlayer()).func_71113_k();
        }
        if (this.isClient()) {
            ItemStack item = inventory.func_70301_a(0);
            this.text.setValue("");
            if (!item.func_190926_b() && !ManagerGenetics.isAnalysed(item)) {
                if (inventory.func_70301_a(1).func_190926_b()) {
                    this.text.setValue(I18N.localise("binniecore.gui.fieldkit.paper.no"));
                    this.isAnalysing = false;
                    this.analyseProgress = 1.0f;
                } else {
                    this.startAnalysing();
                    this.chromo.setSystem(null);
                    if (this.damageKit()) {
                        return;
                    }
                }
            } else if (!item.func_190926_b()) {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                this.refreshSpecies();
                if (this.damageKit()) {
                    return;
                }
            } else {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                this.chromo.setSystem(null);
            }
        }
    }

    private boolean damageKit() {
        return false;
    }

    private void startAnalysing() {
        this.glassVX = 0.0f;
        this.glassVY = 0.0f;
        this.glassOffsetX = 0.0f;
        this.glassOffsetY = 0.0f;
        this.isAnalysing = true;
        this.analyseProgress = 0.0f;
    }

    @Override
    public boolean showHelpButton() {
        return true;
    }

    @Override
    public String showInfoButton() {
        return I18N.localise("binniecore.gui.fieldkit.info");
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        super.receiveGuiNBTOnServer(player, name, nbt);
        if (name.equals("analyse")) {
            WindowInventory inventory = this.getWindowInventory();
            ItemStack individualStack = inventory.func_70301_a(0);
            inventory.func_70299_a(0, ManagerGenetics.analyse(individualStack, this.getWorld(), this.getUsername()));
            inventory.func_70298_a(1, 1);
        }
    }
}

