/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.analyser;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;
import binnie.core.machines.network.INetwork;
import binnie.core.util.EntityItemRenderer;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalyserFX
extends MachineComponent
implements IRender.DisplayTick,
IRender.Render,
INetwork.TilePacketSync {
    private final EntityItemRenderer entityItemRenderer = new EntityItemRenderer();

    public AnalyserFX(IMachine machine) {
        super(machine);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDisplayTick(World world, BlockPos pos, Random rand) {
        if (rand.nextFloat() < 1.0f && this.getUtil().getProcess().isInProgress()) {
            ParticleManager effectRenderer = BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i;
            effectRenderer.func_78873_a((Particle)new AnalyserParticle(world, pos, rand));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld(double x, double y, double z) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        ItemStack itemstack = this.getUtil().getStack(6);
        World world = this.getMachine().getWorld();
        this.entityItemRenderer.renderInWorld(itemstack, world, x + 0.5, y + (double)0.8f, z + 0.5);
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        NBTTagCompound item = new NBTTagCompound();
        ItemStack stack = this.getUtil().getStack(6);
        if (!stack.func_190926_b()) {
            stack.func_77955_b(item);
            nbt.func_74782_a("item", (NBTBase)item);
        }
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("item")) {
            this.getUtil().setStack(6, new ItemStack(nbt.func_74775_l("item")));
        } else {
            this.getUtil().setStack(6, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onInventoryUpdate() {
        if (this.getUtil().isServer()) {
            // empty if block
        }
    }

    private static class AnalyserParticle
    extends Particle {
        public AnalyserParticle(World world, BlockPos pos, Random rand) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.3 + rand.nextDouble() * 0.2, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.field_187129_i = 0.05 * (this.field_187136_p.nextDouble() - 0.5);
            this.field_187131_k = 0.05 * (this.field_187136_p.nextDouble() - 0.5);
            this.field_187130_j = 0.0;
            this.field_70547_e = 25;
            this.field_70545_g = 0.05f;
            this.field_190017_n = true;
            this.func_70538_b(0.6f, 0.0f, 1.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_189213_a() {
            super.func_189213_a();
            this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
        }

        public int func_70537_b() {
            return 0;
        }
    }
}

