/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import binnie.core.Mods;
import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.types.EnumHoneyDrop;
import binnie.extrabees.items.types.EnumPropolis;
import binnie.extrabees.items.types.ExtraBeeItems;
import binnie.extrabees.items.types.IEBEnumItem;
import binnie.extrabees.utils.Utils;
import com.google.common.base.MoreObjects;
import forestry.api.recipes.RecipeManagers;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumHoneyComb implements IEBEnumItem
{
    BARREN(7564356, 12762791){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
        }
    }
    ,
    ROTTEN(4084257, 11652233){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.2f));
            this.addProduct(honeyDrop, Float.valueOf(0.2f));
            this.addProduct(new ItemStack(Items.field_151078_bh, 1, 0), Float.valueOf(0.8f));
        }
    }
    ,
    BONE(12895407, 14606017){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.2f));
            this.addProduct(honeyDrop, Float.valueOf(0.2f));
            this.addProduct(new ItemStack(Items.field_151100_aR, 1, 15), Float.valueOf(0.8f));
        }
    }
    ,
    OIL(394760, 2894646){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumPropolis.OIL, Float.valueOf(0.6f));
            this.addProduct(honeyDrop, Float.valueOf(0.75f));
        }
    }
    ,
    COAL(10392696, 3682590){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.8f));
            this.addProduct(honeyDrop, Float.valueOf(0.75f));
            this.tryAddProduct(ExtraBeeItems.COAL_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    FUEL(10252096, 16761856){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumPropolis.FUEL, Float.valueOf(0.6f));
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
        }
    }
    ,
    WATER(2568911, 7973065){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumPropolis.WATER, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    MILK(14145991, 0xFFFFFF){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumHoneyDrop.MILK, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    FRUIT(8202548, 14372706){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumHoneyDrop.APPLE, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    SEED(0x344F33, 7457902){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumHoneyDrop.SEED, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    ALCOHOL(4293921, 14604622){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumHoneyDrop.ALCOHOL, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    STONE(9211025, 0xC6C6CC){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.5f));
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
        }
    }
    ,
    REDSTONE(16422550, 15077392){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.8f));
            this.addProduct(new ItemStack(Items.field_151137_ax, 1, 0), Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
        }
    }
    ,
    RESIN(16762703, 13208064){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(1.0f));
            this.tryAddProduct(Utils.getIC2Item("itemHarz"), Float.valueOf(1.0f));
            this.tryAddProduct(Utils.getIC2Item("itemHarz"), Float.valueOf(0.5f));
        }
    }
    ,
    IC2ENERGY(15332623, 2143177){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.8f));
            this.addProduct(new ItemStack(Items.field_151137_ax, 1, 0), Float.valueOf(0.75f));
            this.tryAddProduct(EnumHoneyDrop.ENERGY, Float.valueOf(1.0f));
        }
    }
    ,
    IRON(3552564, 11038808){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.IRON_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    GOLD(3552564, 15125515){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.GOLD_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    COPPER(3552564, 13722376){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.COPPER_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    TIN(3552564, 0xBDB1BD){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.TIN_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    SILVER(3552564, 0xDBDBDB){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.SILVER_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    BRONZE,
    URANIUM(2031360, 4303667){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct("crushedUranium", Float.valueOf(0.5f));
        }
    }
    ,
    CLAY(7034426, 11583702){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.25f));
            this.addProduct(honeyDrop, Float.valueOf(0.8f));
            this.addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.8f));
        }
    }
    ,
    OLD(4535060, 11769444){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.9f));
        }
    }
    ,
    FUNGAL(7234891, 2856003){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.9f));
            this.addProduct(new ItemStack(Blocks.field_150420_aW, 1, 0), Float.valueOf(1.0f));
            this.addProduct(new ItemStack(Blocks.field_150419_aX, 1, 0), Float.valueOf(0.75f));
        }
    }
    ,
    CREOSOTE(10256652, 12429911){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumPropolis.CREOSOTE, Float.valueOf(0.7f));
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
        }
    }
    ,
    LATEX(5854529, 11051653){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
            this.addProduct(beeswax, Float.valueOf(0.85f));
            this.tryAddProduct("itemRubber", Float.valueOf(1.0f));
        }
    }
    ,
    ACIDIC(3441987, 1374014){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.8f));
            this.tryAddProduct(EnumHoneyDrop.ACID, Float.valueOf(0.5f));
            this.tryAddProduct("dustSulfur", Float.valueOf(0.75f));
        }
    }
    ,
    VENOMOUS(8198269, 0xFF33FF){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.8f));
            this.tryAddProduct(EnumHoneyDrop.POISON, Float.valueOf(0.8f));
        }
    }
    ,
    SLIME(3884860, 8442245){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(1.0f));
            this.addProduct(honeyDrop, Float.valueOf(0.75f));
            this.addProduct(new ItemStack(Items.field_151123_aH, 1, 0), Float.valueOf(0.75f));
        }
    }
    ,
    BLAZE(16738816, 0xFFCC00){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.75f));
            this.addProduct(new ItemStack(Items.field_151065_br, 1, 0), Float.valueOf(1.0f));
        }
    }
    ,
    COFFEE(5519389, 11763531){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(beeswax, Float.valueOf(0.9f));
            this.addProduct(honeyDrop, Float.valueOf(0.75f));
            this.tryAddProduct(Utils.getIC2Item("itemCofeePowder"), Float.valueOf(0.75f));
        }
    }
    ,
    GLACIAL(5146503, 13366002){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct(EnumHoneyDrop.ICE, Float.valueOf(0.8f));
            this.addProduct(honeyDrop, Float.valueOf(0.75f));
        }
    }
    ,
    MINT,
    CITRUS,
    PEAT,
    SHADOW(0, 3545141){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.5f));
            this.tryAddProduct("dustObsidian", Float.valueOf(0.75f));
        }
    }
    ,
    LEAD(3552564, 10125468){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.LEAD_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    BRASS,
    ELECTRUM,
    ZINC(3552564, 15592447){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.ZINC_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    TITANIUM(3552564, 11578083){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.TITANIUM_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    TUNGSTEN(3552564, 1249812){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.TUNGSTEN_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    STEEL,
    IRIDIUM,
    PLATINUM(3552564, 10125468){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.PLATINUM_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    LAPIS(3552564, 4009179){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.addProduct(new ItemStack(Items.field_151100_aR, 6, 4), Float.valueOf(1.0f));
        }
    }
    ,
    SODALITE(3552564, 1396717){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct("dustSmallSodalite", Float.valueOf(1.0f));
            this.tryAddProduct("dustSmallAluminum", Float.valueOf(1.0f));
            this.copyProducts(STONE);
        }
    }
    ,
    PYRITE(3552564, 14919481){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct("dustSmallPyrite", Float.valueOf(1.0f));
            this.tryAddProduct("dustSmallIron", Float.valueOf(1.0f));
            this.copyProducts(STONE);
        }
    }
    ,
    BAUXITE(3552564, 10249472){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct("dustSmallBauxite", Float.valueOf(1.0f));
            this.tryAddProduct("dustSmallAluminum", Float.valueOf(1.0f));
            this.copyProducts(STONE);
        }
    }
    ,
    CINNABAR(3552564, 4665867){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct("dustSmallCinnabar", Float.valueOf(1.0f));
            this.addProduct(new ItemStack(Items.field_151137_ax), Float.valueOf(0.05f));
            this.copyProducts(STONE);
        }
    }
    ,
    SPHALERITE(3552564, 14406941){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.tryAddProduct("dustSmallSphalerite", Float.valueOf(1.0f));
            this.tryAddProduct("dustSmallZinc", Float.valueOf(1.0f));
            this.copyProducts(STONE);
        }
    }
    ,
    EMERALD(3552564, 1900291){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.EMERALD_SHARD, Float.valueOf(1.0f));
        }
    }
    ,
    RUBY(3552564, 0xD60000){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.RUBY_SHARD, Float.valueOf(1.0f));
        }
    }
    ,
    SAPPHIRE(3552564, 673791){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.SAPPHIRE_SHARD, Float.valueOf(1.0f));
        }
    }
    ,
    OLIVINE,
    DIAMOND(3552564, 8371706){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.DIAMOND_SHARD, Float.valueOf(1.0f));
        }
    }
    ,
    RED(0xCC4C4C, 0xFF0000){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    YELLOW(0xE5E533, 0xFFDD00){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    BLUE(10072818, 8959){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    GREEN(6717235, 39168){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    BLACK(0x191919, 0x575757){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    WHITE(0xD6D6D6, 0xFFFFFF){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    BROWN(8349260, 6042895){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    ORANGE(15905331, 16751872){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    CYAN(5020082, 65509){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    PURPLE(11691749, 11403519){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    GRAY(0x4C4C4C, 0xBABABA){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    LIGHTBLUE(10072818, 40447){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    PINK(15905484, 16744671){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    LIMEGREEN(8375321, 65288){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    MAGENTA(15040472, 0xFF00CC){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    LIGHTGRAY(0x999999, 0xC9C9C9){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addDyeSubtypes(beeswax, honeyDrop);
        }
    }
    ,
    NICKEL(3552564, 16768764){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.NICKEL_DUST, Float.valueOf(1.0f));
        }
    }
    ,
    INVAR,
    GLOWSTONE(10919006, 14730249){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
            this.addProduct(new ItemStack(Items.field_151114_aO), Float.valueOf(1.0f));
        }
    }
    ,
    SALTPETER(10919006, 14730249){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
            this.tryAddProduct("dustSaltpeter", Float.valueOf(1.0f));
        }
    }
    ,
    PULP,
    MULCH,
    COMPOST(4338440, 7036475){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
            ItemStack compost = Mods.Forestry.stack("fertilizer_bio");
            this.tryAddProduct(compost, Float.valueOf(1.0f));
        }
    }
    ,
    SAWDUST(12561009, 15913854){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            SAWDUST.addProduct(honeyDrop, Float.valueOf(0.25f));
            SAWDUST.tryAddProduct("dustSawdust", Float.valueOf(1.0f));
            if (!this.isActive()) {
                this.tryAddProduct("sawdust", Float.valueOf(1.0f));
            }
        }
    }
    ,
    CERTUS(13029631, 3755363){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
            this.addProduct(new ItemStack(Items.field_151128_bU), Float.valueOf(0.25f));
            this.tryAddProduct("dustCertusQuartz", Float.valueOf(0.2f));
        }
    }
    ,
    ENDERPEARL(3446662, 206368){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.addProduct(honeyDrop, Float.valueOf(0.25f));
            this.tryAddProduct("dustEnderPearl", Float.valueOf(0.25f));
        }
    }
    ,
    YELLORIUM(2564173, 14019840){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.YELLORIUM_DUST, Float.valueOf(0.25f));
        }
    }
    ,
    CYANITE(2564173, 34541){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.CYANITE_DUST, Float.valueOf(0.25f));
        }
    }
    ,
    BLUTONIUM(2564173, 1769702){

        @Override
        protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
            this.copyProducts(STONE);
            this.tryAddProduct(ExtraBeeItems.BLUTONIUM_DUST, Float.valueOf(0.25f));
        }
    };

    private final int primaryColor;
    private final int secondaryColor;
    private final Map<ItemStack, Float> products = new LinkedHashMap<ItemStack, Float>();
    private boolean active = true;

    private EnumHoneyComb() {
        this(0xFFFFFF, 0xFFFFFF);
        this.active = false;
    }

    private EnumHoneyComb(int secondaryColor, int primaryColor) {
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    public static EnumHoneyComb get(ItemStack itemStack) {
        int i = itemStack.func_77952_i();
        if (i >= 0 && i < EnumHoneyComb.values().length) {
            return EnumHoneyComb.values()[i];
        }
        return EnumHoneyComb.values()[0];
    }

    public int getSpriteColour(int renderPass) {
        if (renderPass == 0) {
            return this.primaryColor;
        }
        if (renderPass == 1) {
            return this.secondaryColor;
        }
        return 0xFFFFFF;
    }

    protected void addSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
    }

    protected void addDyeSubtypes(ItemStack beeswax, ItemStack honeyDrop) {
        this.addProduct(honeyDrop, Float.valueOf(0.8f));
        this.addProduct(beeswax, Float.valueOf(0.8f));
        int index = this.ordinal() - RED.ordinal();
        EnumHoneyDrop drop = EnumHoneyDrop.values()[EnumHoneyDrop.RED.ordinal() + index];
        int[] dyeMetas = new int[]{1, 11, 4, 2, 0, 15, 3, 14, 6, 5, 8, 12, 9, 10, 13, 7};
        int meta = dyeMetas[index];
        ItemStack dye = new ItemStack(Items.field_151100_aR, 1, meta);
        switch (meta) {
            case 0: {
                dye = ExtraBeeItems.BLACK_DYE.get(1);
                break;
            }
            case 1: {
                dye = ExtraBeeItems.RED_DYE.get(1);
                break;
            }
            case 2: {
                dye = ExtraBeeItems.GREEN_DYE.get(1);
                break;
            }
            case 3: {
                dye = ExtraBeeItems.BROWN_DYE.get(1);
                break;
            }
            case 4: {
                dye = ExtraBeeItems.BLUE_DYE.get(1);
                break;
            }
            case 11: {
                dye = ExtraBeeItems.YELLOW_DYE.get(1);
                break;
            }
            case 15: {
                dye = ExtraBeeItems.WHITE_DYE.get(1);
            }
        }
        this.addProduct(drop.get(1), Float.valueOf(1.0f));
        drop.addRemnant(dye);
    }

    public static void addSubtypes() {
        OreDictionary.registerOre((String)"beeComb", (ItemStack)new ItemStack(ExtraBees.comb, 1, Short.MAX_VALUE));
        ItemStack beeswax = Mods.Forestry.stack("beeswax");
        ItemStack honeyDrop = Mods.Forestry.stack("honey_drop");
        for (EnumHoneyComb comb : EnumHoneyComb.values()) {
            comb.addSubtypes(beeswax, honeyDrop);
        }
    }

    public void addRecipe() {
        if (this.isActive()) {
            RecipeManagers.centrifugeManager.addRecipe(20, this.get(1), this.products);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ItemStack get(int amount) {
        return new ItemStack(ExtraBees.comb, amount, this.ordinal());
    }

    @Override
    public String getName(ItemStack itemStack) {
        return I18N.localise("extrabees.item.comb." + this.name().toLowerCase());
    }

    public boolean addProduct(@Nullable Item item, Float chance) {
        return this.addProduct(new ItemStack((Item)MoreObjects.firstNonNull((Object)item, (Object)Item.func_150898_a((Block)Blocks.field_150350_a))), chance);
    }

    public boolean addProduct(ItemStack item, Float chance) {
        if (item.func_190926_b()) {
            return false;
        }
        this.products.put(item.func_77946_l(), chance);
        return true;
    }

    public void tryAddProduct(ItemStack item, Float chance) {
        this.active = this.addProduct(item, chance);
    }

    public void tryAddProduct(@Nullable Item item, Float chance) {
        this.active = this.addProduct(item, chance);
    }

    public void tryAddProduct(String oreDict, Float chance) {
        if (!OreDictionary.getOres((String)oreDict).isEmpty()) {
            this.tryAddProduct((ItemStack)OreDictionary.getOres((String)oreDict).get(0), chance);
        } else {
            this.active = false;
        }
    }

    public void tryAddProduct(IEBEnumItem type, Float chance) {
        this.tryAddProduct(type.get(1), chance);
        this.active = this.active && type.isActive();
    }

    public void copyProducts(EnumHoneyComb comb) {
        this.products.putAll(comb.products);
    }
}

