/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics.gui.analyst;

import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.genetics.gui.analyst.AnalystPageAppearance;
import binnie.botany.genetics.gui.analyst.AnalystPageSoil;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.util.I18N;
import binnie.core.util.TimeUtil;
import binnie.genetics.api.analyst.IAnalystManager;
import binnie.genetics.api.analyst.IAnalystPagePlugin;
import binnie.genetics.api.analyst.IBiologyPlugin;
import binnie.genetics.api.analyst.IClimatePlugin;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IIndividual;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlowerAnalystPagePlugin
implements IAnalystPagePlugin<IFlower> {
    @Override
    public boolean handles(IIndividual individual) {
        return individual instanceof IFlower;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAnalystPages(IFlower individual, IWidget parent, IArea pageSize, List<ITitledWidget> analystPages, IAnalystManager analystManager) {
        analystPages.add(analystManager.createClimatePage(parent, pageSize, individual, new ClimatePlugin()));
        analystPages.add(new AnalystPageSoil(parent, pageSize, individual));
        analystPages.add(analystManager.createBiologyPage(parent, pageSize, individual, new BiologyPlugin()));
        analystPages.add(new AnalystPageAppearance(parent, pageSize, individual));
    }

    private static class ClimatePlugin
    implements IClimatePlugin<IFlower> {
        private ClimatePlugin() {
        }

        @Override
        public EnumTolerance getTemperatureTolerance(IFlower flower) {
            IFlowerGenome genome = flower.getGenome();
            IAlleleTolerance tolerance = (IAlleleTolerance)genome.getActiveAllele(EnumFlowerChromosome.TEMPERATURE_TOLERANCE);
            return tolerance.getValue();
        }

        @Override
        public EnumTolerance getHumidityTolerance(IFlower flower) {
            return EnumTolerance.BOTH_5;
        }

        @Override
        public boolean showHumiditySection() {
            return false;
        }
    }

    private static class BiologyPlugin
    implements IBiologyPlugin<IFlower> {
        private BiologyPlugin() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int addBiologyPages(IFlower flower, IWidget parent, int y, IAnalystManager analystManager) {
            int butterflySpawn2 = Math.round(1365.3999f / (flower.getGenome().getSappiness() * 0.2f));
            new ControlTextCentered(parent, y += 10, I18N.localise("genetics.gui.analyst.biology.mothSpawn", TimeUtil.getTimeString(butterflySpawn2))).setColor(parent.getColor());
            y += 30;
            int fertility = flower.getGenome().getFertility();
            float chanceDispersal = 0.8f;
            chanceDispersal += 0.2f * (float)fertility;
            if (chanceDispersal > 1.0f) {
                chanceDispersal = 1.0f;
            }
            float chancePollinate = 0.6f;
            if ((chancePollinate += 0.25f * (float)fertility) > 1.0f) {
                chancePollinate = 1.0f;
            }
            float maxAge = flower.getMaxAge();
            float ageChance = flower.getGenome().getAgeChance();
            float dispersalTime = 1365.3999f / chanceDispersal;
            float pollinateTime = 1365.3999f / chancePollinate;
            float lifespan2 = maxAge * 20.0f * 68.27f / ageChance;
            float floweringLifespan = (maxAge - 1.0f) * 20.0f * 68.27f / ageChance - 1365.3999f;
            new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.biology.averageLifespan")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.BOLD + TimeUtil.getMCDayString(lifespan2)).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 22, I18N.localise("genetics.gui.analyst.biology.seedDispersal")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.perLifetime", (int)(floweringLifespan / dispersalTime))).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 22, I18N.localise("genetics.gui.analyst.biology.pollination")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.perLifetime", (int)(floweringLifespan / pollinateTime))).setColor(parent.getColor());
            return y += 22;
        }
    }
}

