/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.fruits;

import binnie.extratrees.genetics.fruits.ETFruitProviderNone;
import binnie.extratrees.genetics.fruits.FruitSprite;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ETFruitProviderRipening
extends ETFruitProviderNone {
    private int diffR;
    private int diffG;
    private int diffB;
    private int ripeningPeriod;
    private int colourCallow = 0xFFFFFF;
    @Nullable
    private final FruitSprite sprite;

    public ETFruitProviderRipening(String name, IFruitFamily family, FruitSprite sprite) {
        super(name, family);
        this.sprite = sprite;
    }

    public ETFruitProviderRipening setColours(Color ripe, Color callow) {
        this.colourCallow = callow.getRGB();
        int ripeRGB = ripe.getRGB();
        this.diffR = (ripeRGB >> 16 & 0xFF) - (this.colourCallow >> 16 & 0xFF);
        this.diffG = (ripeRGB >> 8 & 0xFF) - (this.colourCallow >> 8 & 0xFF);
        this.diffB = (ripeRGB & 0xFF) - (this.colourCallow & 0xFF);
        return this;
    }

    public ETFruitProviderRipening setRipeningPeriod(int period) {
        this.ripeningPeriod = period;
        return this;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return ripeningTime / this.ripeningPeriod;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        return this.getColour(stage);
    }

    private int getColour(float stage) {
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public boolean isFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        this.sprite.registerSprites();
    }

    @Override
    @Nullable
    public ResourceLocation getSprite(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        if (this.sprite != null) {
            return this.sprite.getLocation();
        }
        return null;
    }
}

