/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidType;
import binnie.core.util.I18N;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraftforge.fluids.FluidStack;

public class CocktailLiquid
implements ICocktailLiquid {
    private final FluidType definition;
    private final float abv;

    public CocktailLiquid(FluidType definition, float abv) {
        this.definition = definition;
        this.abv = abv;
    }

    @Override
    public FluidStack get(int amount) {
        return this.definition.get(amount);
    }

    @Override
    public String getDisplayName() {
        return this.definition.getDisplayName();
    }

    @Override
    public String getIdentifier() {
        return this.definition.getIdentifier();
    }

    @Override
    public int getColor() {
        return this.definition.getColor();
    }

    @Override
    public int getTransparency() {
        return this.definition.getTransparency();
    }

    @Override
    public String getTooltip(int ratio) {
        String unlocalized = "extratrees.cocktail.liquid.tooltip";
        if (ratio > 1) {
            unlocalized = "extratrees.cocktail.liquids.tooltip";
        }
        return I18N.localise(unlocalized, ratio, this.definition.getDisplayName());
    }

    @Override
    public float getABV() {
        return this.abv;
    }
}

