/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.ModId;
import binnie.core.machines.inventory.BaseSlot;
import binnie.core.machines.inventory.Validator;
import binnie.core.util.I18N;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TankSlot
extends BaseSlot<FluidStack> {
    private final FluidTank tank;

    @Deprecated
    public TankSlot(int index, String name, int capacity) {
        this(index, new ResourceLocation("binniecore", "gui.tank." + name), capacity);
    }

    public TankSlot(int index, ResourceLocation name, int capacity) {
        super(index, name);
        this.tank = new FluidTank(capacity);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
        this.setContent(liquid);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.getContent() != null) {
            this.getContent().writeToNBT(nbttagcompound);
        }
        return nbttagcompound;
    }

    @Override
    public FluidStack getContent() {
        return this.tank.getFluid();
    }

    public void setContent(FluidStack itemStack) {
        this.tank.setFluid(itemStack);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public String getName() {
        Validator validator = this.getValidator();
        if (validator != null) {
            return I18N.localise(ModId.CORE, "gui.tank.validated", validator.getTooltip());
        }
        if (this.unlocLocation == null) {
            return "";
        }
        return I18N.localise(this.unlocLocation);
    }
}

