/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.genepool;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.IProcess;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.machine.GeneticsErrorCode;
import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.item.ItemStack;

public class GenepoolLogic
extends ComponentProcessSetCost
implements IProcess {
    public static final float ENZYME_PER_PROCESS = 0.25f;
    private float ethanolDrain = 0.0f;

    public GenepoolLogic(Machine machine) {
        super(machine, 8000, 400);
    }

    public static int getDNAAmount(ItemStack stack) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root == BeeManager.beeRoot) {
            if (BeeManager.beeRoot.isDrone(stack)) {
                return 10;
            }
            if (BeeManager.beeRoot.isMated(stack)) {
                return 50;
            }
            return 30;
        }
        return 10;
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        ItemStack individual;
        MachineUtil util = this.getUtil();
        if (!util.spaceInTank(0, GenepoolLogic.getDNAAmount(individual = util.getStack(0)))) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.NO_SPACE_TANK, new int[]{0});
        }
        if (!util.liquidInTank(1, 1)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.GENEPOOL_INSUFFICIENT_ETHANOL, 1);
        }
        if (util.getSlotCharge(7) == 0.0f) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.GENEPOOL_INSUFFICIENT_ENZYME, 7);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        MachineUtil util = this.getUtil();
        ItemStack individual = util.getStack(0);
        int amount = GenepoolLogic.getDNAAmount(individual);
        util.fillTank(0, GeneticLiquid.RawDNA.get(amount));
        util.deleteStack(0);
    }

    @Override
    protected void onTickTask() {
        MachineUtil util = this.getUtil();
        ItemStack individual = util.getStack(0);
        this.ethanolDrain += (float)GenepoolLogic.getDNAAmount(individual) * 1.2f * this.getProgressPerTick() / 100.0f;
        if (this.ethanolDrain >= 1.0f) {
            util.drainTank(1, 1);
            this.ethanolDrain -= 1.0f;
        }
        IChargedSlots chargedSlots = this.getMachine().getInterface(IChargedSlots.class);
        chargedSlots.alterCharge(7, -0.25f * this.getProgressPerTick() / 100.0f);
    }
}

