/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.ModId;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.minecraft.Window;
import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.util.I18N;
import java.text.NumberFormat;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlProgressBase
extends Control {
    protected float progress = 0.0f;

    public ControlProgressBase(IWidget parent, int x, int y, int w, int h) {
        super(parent, x, y, w, h);
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    public static String convertTime(int time) {
        int seconds;
        int minutes = 0;
        for (seconds = (int)((float)time / 20.0f); seconds >= 60; seconds -= 60) {
            ++minutes;
        }
        String ts = "";
        if (minutes > 0) {
            ts = ts + minutes + " minute" + (minutes == 1 ? "" : "s");
        }
        if (seconds > 0) {
            if (ts.length() > 0) {
                ts = ts + " ";
            }
            ts = ts + seconds + " second" + (seconds == 1 ? "" : "s");
        }
        return ts;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
        } else if (this.progress > 1.0f) {
            this.progress = 1.0f;
        }
    }

    protected ProcessInfo getProcess() {
        return ((Window)Window.get(this)).getContainer().getProcessInfo();
    }

    @Override
    public void onUpdateClient() {
        ProcessInfo process = this.getProcess();
        if (process != null) {
            this.setProgress(process.getCurrentProgress() / 100.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getHelpTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        ProcessInfo process = this.getProcess();
        if (process != null) {
            tooltip.add(I18N.localise(ModId.CORE, "gui.progress.title", new Object[0]));
            if (this.progress == 0.0f) {
                tooltip.add(I18N.localise(ModId.CORE, "gui.progress.no.progress", new Object[0]));
            } else if (process.getProcessTime() > 0) {
                IProcess machineProcess = Machine.getMachine(((Window)Window.get(this)).getInventory()).getInterface(IProcess.class);
                String percentProgress = I18N.getPercentFormat().format((double)((int)process.getCurrentProgress()) / 100.0);
                tooltip.add(machineProcess.getTooltip() + " (" + percentProgress + ")");
            } else {
                tooltip.add(I18N.localise(ModId.CORE, "gui.progress.in.progress", new Object[0]));
            }
            if (tooltipFlag.func_194127_a()) {
                NumberFormat numberFormat = I18N.getNumberFormat();
                if (process.getProcessTime() > 0) {
                    String timeLeft = ControlProgressBase.convertTime((int)((1.0f - this.progress) * (float)process.getProcessTime()));
                    tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.progress.time.left", timeLeft));
                    String timeTotal = ControlProgressBase.convertTime(process.getProcessTime());
                    tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.progress.time.total", timeTotal));
                    String energyCostTotal = numberFormat.format(process.getProcessEnergy() * 10);
                    tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.progress.energy.cost.total", energyCostTotal));
                } else {
                    String energyCostPerTick = numberFormat.format(process.getEnergyPerTick() * 10.0f);
                    tooltip.add(TextFormatting.GRAY + I18N.localise(ModId.CORE, "gui.energy.cost.per.tick", energyCostPerTick));
                }
            }
        }
    }

    @Override
    public boolean showBasicHelpTooltipsByDefault() {
        return true;
    }
}

