/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics.gui.analyst;

import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.gui.database.ControlColorDisplay;
import binnie.botany.models.FlowerSpriteManager;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlIconDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageAppearance
extends Control
implements ITitledWidget {
    public AnalystPageAppearance(IWidget parent, IArea area, IFlower flower) {
        super(parent, area);
        this.setColor(0x333333);
        int y = 4;
        IFlowerGenome genome = flower.getGenome();
        IAlleleFlowerSpecies species = genome.getPrimary();
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        ControlColorDisplay a = new ControlColorDisplay(this, this.getWidth() / 2 - 28, y += 12, genome.getPrimaryColor());
        a.addTooltip(I18N.localise("genetics.gui.analyst.appearance.primary"));
        ControlColorDisplay b = new ControlColorDisplay(this, this.getWidth() / 2 - 8, y, genome.getSecondaryColor());
        b.addTooltip(I18N.localise("genetics.gui.analyst.appearance.secondary"));
        ControlColorDisplay c = new ControlColorDisplay(this, this.getWidth() / 2 + 12, y, genome.getStemColor());
        c.addTooltip(I18N.localise("genetics.gui.analyst.appearance.stem"));
        IFlowerType type = genome.getType();
        int sections = type.getSections();
        int width = sections > 1 ? 50 : 100;
        new FlowerIconDisplay(this, width, y += 26, sections, flower, type);
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.appearance.title");
    }

    private static class FlowerIconDisplay
    extends ControlIconDisplay {
        private final int width;
        private final int sections;
        private final IFlower flower;
        private final IFlowerType type;

        public FlowerIconDisplay(AnalystPageAppearance analystPageAppearance, int width, int y, int sections, IFlower flower, IFlowerType type) {
            super(analystPageAppearance, (analystPageAppearance.getWidth() - width) / 2, y - (sections == 1 ? 0 : 0));
            this.width = width;
            this.sections = sections;
            this.flower = flower;
            this.type = type;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRenderForeground(int guiWidth, int guiHeight) {
            GlStateManager.func_179094_E();
            float scale = (float)this.width / 16.0f;
            int dy = this.sections > 1 ? 16 : 0;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            RenderUtil.setColour(this.flower.getGenome().getStemColor().getColor(false));
            if (this.sections > 1) {
                RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getStem(this.type, 1, true));
            }
            RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getStem(this.type, 0, true));
            RenderUtil.setColour(this.flower.getGenome().getPrimaryColor().getColor(false));
            if (this.sections > 1) {
                RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getPetal(this.type, 1, true));
            }
            RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getPetal(this.type, 0, true));
            RenderUtil.setColour(this.flower.getGenome().getSecondaryColor().getColor(false));
            if (this.sections > 1) {
                RenderUtil.drawSprite(Point.ZERO, FlowerSpriteManager.getVariant(this.type, 1, true));
            }
            RenderUtil.drawSprite(new Point(0, dy), FlowerSpriteManager.getVariant(this.type, 0, true));
            GlStateManager.func_179121_F();
        }
    }
}

