/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.gui.analyst;

import binnie.core.BinnieCore;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.ControlFluidDisplay;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.CraftGUIUtil;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.FluidStackUtil;
import binnie.core.util.ForestryRecipeUtil;
import binnie.core.util.I18N;
import binnie.core.util.TimeUtil;
import binnie.core.util.UniqueItemStackSet;
import binnie.extrabees.ExtraBees;
import binnie.genetics.api.analyst.IAnalystManager;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IChromosomeType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystPageBeeProducts
extends Control
implements ITitledWidget {
    public AnalystPageBeeProducts(IWidget parent, IArea area, IBee ind, IAnalystManager analystManager) {
        super(parent, area);
        this.setColor(0xCC3300);
        IBeeGenome genome = ind.getGenome();
        float speed = genome.getSpeed();
        float modeSpeed = BeeManager.beeRoot.getBeekeepingMode(BinnieCore.getBinnieProxy().getWorld()).getBeeModifier().getProductionModifier(genome, 1.0f);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.products.rate") + ": " + ExtraBees.beeBreedingSystem.getAlleleName((IChromosomeType)EnumBeeChromosome.SPEED, ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.SPEED))).setColor(this.getColor());
        y += 20;
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        UniqueItemStackSet productList = new UniqueItemStackSet();
        UniqueItemStackSet specialtyList = new UniqueItemStackSet();
        Map products = new HashMap();
        products.putAll(genome.getPrimary().getProductChances());
        products.putAll(genome.getSecondary().getProductChances());
        if (!products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.natural")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                if (!productList.add(entry.getKey())) continue;
                refinedProducts.addAll(analystManager.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        if (!(products = genome.getPrimary().getSpecialtyChances()).isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.specialty")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                refinedProducts.addAll(analystManager.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.refined")).setColor(this.getColor());
        y += 12;
        UniqueItemStackSet level2Products = new UniqueItemStackSet();
        for (ItemStack stack : refinedProducts) {
            level2Products.addAll(analystManager.getAllProducts(stack));
        }
        refinedProducts.addAll(level2Products);
        level2Products = new UniqueItemStackSet();
        for (ItemStack stack : refinedProducts) {
            level2Products.addAll(analystManager.getAllProducts(stack));
        }
        refinedProducts.addAll(level2Products);
        NonNullList<FluidStack> allFluids = analystManager.getAllFluidsFromItems(refinedProducts);
        int maxBiomePerLine = (int)(((float)this.getWidth() + 2.0f - 16.0f) / 18.0f);
        int biomeListX = (this.getWidth() - (Math.min(maxBiomePerLine, allFluids.size() + refinedProducts.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : refinedProducts) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ControlItemDisplay display = new ControlItemDisplay(this, biomeListX + dx, y + dy);
            display.setItemStack(soilStack);
            display.setTooltip();
            dx += 18;
        }
        for (FluidStack fluidStack : allFluids) {
            ItemStack container;
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            if ((container = FluidStackUtil.getContainer(fluidStack)) == null) {
                ControlFluidDisplay display2 = new ControlFluidDisplay(this, biomeListX + dx, y + dy);
                display2.setFluidStack(fluidStack);
                display2.setTooltip();
            } else {
                ControlItemDisplay display3 = new ControlItemDisplay(this, biomeListX + dx, y + dy);
                display3.setItemStack(container);
                display3.setTooltip();
            }
            dx += 18;
        }
        this.setSize(new Point(this.getWidth(), y + dy + 18 + 8));
    }

    private void createProductEntry(ItemStack key, Float value, int y, float speed) {
        BeeProductItem item = new BeeProductItem(this, y, key);
        item.setTooltip();
        ControlTextCentered textWidget = new ControlTextCentered((IWidget)this, y + 4, "");
        textWidget.setColor(this.getColor());
        CraftGUIUtil.moveWidget(textWidget, new Point(12, 0));
        item.setItemStack(key);
        int time = (int)(55000.0 / (double)(speed * value.floatValue()));
        textWidget.setValue(I18N.localise("genetics.gui.analyst.products.every") + " " + TimeUtil.getTimeString(time));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.products.title");
    }

    private static class BeeProductItem
    extends ControlItemDisplay {
        private final ItemStack key;

        public BeeProductItem(AnalystPageBeeProducts analystPageBeeProducts, int y, ItemStack key) {
            super(analystPageBeeProducts, 16, y);
            this.key = key;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
            super.getTooltip(tooltip, tooltipFlag);
            NonNullList centrifugeProducts = NonNullList.func_191196_a();
            ForestryRecipeUtil.getCentrifugeOutputs(this.key, (NonNullList<ItemStack>)centrifugeProducts);
            if (!centrifugeProducts.isEmpty()) {
                tooltip.add(I18N.localise("genetics.gui.analyst.products.centrifuges") + ": ");
                for (ItemStack prod : centrifugeProducts) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    prod.func_77955_b(nbt);
                    tooltip.add(prod, prod.func_82833_r());
                }
            }
            NonNullList squeezerProducts = NonNullList.func_191196_a();
            ForestryRecipeUtil.getSqueezerOutputs(this.key, (NonNullList<ItemStack>)squeezerProducts);
            if (!squeezerProducts.isEmpty()) {
                tooltip.add(I18N.localise("genetics.gui.analyst.products.squeezes") + ": ");
                for (ItemStack prod2 : squeezerProducts) {
                    NBTTagCompound nbt2 = new NBTTagCompound();
                    prod2.func_77955_b(nbt2);
                    tooltip.add(prod2, prod2.func_82833_r());
                }
            }
        }
    }
}

