/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.controls.ControlCheckbox;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Dialog;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.core.machines.storage.WindowCompartment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SearchDialog
extends Dialog {
    private final Control slotGrid;
    private final WindowCompartment windowCompartment;
    private String textSearch = "";
    private boolean sortByName;
    private boolean includeItems = true;
    private boolean includeBlocks = true;

    public SearchDialog(WindowCompartment windowCompartment) {
        super(windowCompartment, 252, 192);
        this.windowCompartment = windowCompartment;
        SearchScrollContent scroll = new SearchScrollContent(this);
        this.slotGrid = new Control(scroll, 1, 1, 108, 18);
        scroll.setScrollableContent(this.slotGrid);
        new ControlPlayerInventory((IWidget)this, true);
        new ControlTextEdit(this, 16, 16, 100, 14).addEventHandler(EventTextEdit.class, event -> {
            this.textSearch = (String)event.getValue();
            this.updateSearch();
        });
        this.includeItems = true;
        this.includeBlocks = true;
        new SortAlphabeticalCheckbox(this);
        new IncludeItemsCheckbox(this);
        new IncludeBlocksCheckbox(this);
        this.updateSearch();
    }

    private void updateSearch() {
        HashMap<Integer, Object> slotIds = new HashMap<Integer, Object>();
        IInventory inv = this.windowCompartment.getInventory();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            String name = stack.func_82833_r().toLowerCase();
            if (this.textSearch != null && !name.contains(this.textSearch) || !this.includeBlocks && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || !this.includeItems && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
            slotIds.put(i, name);
        }
        if (this.sortByName) {
            LinkedList list = new LinkedList(slotIds.entrySet());
            list.sort((o1, o2) -> -((String)o2.getValue()).compareTo((String)o1.getValue()));
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : list) {
                result.put(entry.getKey(), entry.getValue());
            }
            slotIds = result;
        }
        int y = 0;
        int x = 0;
        int width = 108;
        int n = 2 + 18 * (1 + (slotIds.size() - 1) / 6);
        this.slotGrid.deleteAllChildren();
        this.slotGrid.setSize(new Point(108, n));
        Iterator iterator = slotIds.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            new ControlSlot.Builder(this.slotGrid, x, y).assign(k);
            if ((x += 18) < 108) continue;
            x = 0;
            y += 18;
        }
        while (y < 108 || x != 0) {
            new ControlSlot.Builder(this.slotGrid, x, y);
            if ((x += 18) < 108) continue;
            x = 0;
            y += 18;
        }
    }

    private static class IncludeBlocksCheckbox
    extends ControlCheckbox {
        private final SearchDialog searchDialog;

        public IncludeBlocksCheckbox(SearchDialog searchDialog) {
            super(searchDialog, 16, 88, 100, "Include Blocks", searchDialog.includeBlocks);
            this.searchDialog = searchDialog;
        }

        @Override
        protected void onValueChanged(boolean value) {
            this.searchDialog.includeBlocks = value;
            this.searchDialog.updateSearch();
        }
    }

    private static class IncludeItemsCheckbox
    extends ControlCheckbox {
        private final SearchDialog searchDialog;

        public IncludeItemsCheckbox(SearchDialog searchDialog) {
            super(searchDialog, 16, 64, 100, "Include Items", searchDialog.includeItems);
            this.searchDialog = searchDialog;
        }

        @Override
        protected void onValueChanged(boolean value) {
            this.searchDialog.includeItems = value;
            this.searchDialog.updateSearch();
        }
    }

    private static class SortAlphabeticalCheckbox
    extends ControlCheckbox {
        private final SearchDialog searchDialog;

        public SortAlphabeticalCheckbox(SearchDialog searchDialog) {
            super(searchDialog, 16, 40, 100, "Sort A-Z", searchDialog.sortByName);
            this.searchDialog = searchDialog;
        }

        @Override
        protected void onValueChanged(boolean value) {
            this.searchDialog.sortByName = value;
            this.searchDialog.updateSearch();
        }
    }

    private static class SearchScrollContent
    extends ControlScrollableContent<IWidget> {
        private final SearchDialog searchDialog;

        public SearchScrollContent(SearchDialog searchDialog) {
            super(searchDialog, 124, 16, 116, 92, 6);
            this.searchDialog = searchDialog;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRenderBackground(int guiWidth, int guiHeight) {
            RenderUtil.setColour(0xAAAAAA);
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, this.searchDialog.windowCompartment.getArea().inset(new Border(0, 6, 0, 0)));
        }
    }
}

