/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ComponentTankContainer
extends MachineComponent
implements ITankMachine {
    private final Map<Integer, TankSlot> tanks = new LinkedHashMap<Integer, TankSlot>();
    private final EnumMap<EnumFacing, IFluidHandler> handlers = new EnumMap(EnumFacing.class);
    private final IFluidHandler noFacingHandler;

    public ComponentTankContainer(IMachine machine) {
        super(machine);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.handlers.put(facing, new TankContainer(facing));
        }
        this.noFacingHandler = new TankContainer(null);
    }

    @Override
    public final TankSlot addTank(int index, String name, int capacity) {
        TankSlot tank = new TankSlot(index, name, capacity);
        this.tanks.put(index, tank);
        return tank;
    }

    @Override
    public final TankSlot addTank(int index, ResourceLocation name, int capacity) {
        TankSlot tank = new TankSlot(index, name, capacity);
        this.tanks.put(index, tank);
        return tank;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (!this.tanks.containsKey(tankIndex)) {
            return 0;
        }
        if (!this.isLiquidValidForTank(resource, tankIndex)) {
            return 0;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        int filled = tank.getTank().fill(resource, doFill);
        if (filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    @Nullable
    private FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (!this.tanks.containsKey(tankIndex)) {
            return null;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        FluidStack drained = tank.getTank().drain(maxDrain, doDrain);
        if (drained != null) {
            this.markDirty();
        }
        return drained;
    }

    private int getTankIndexToFill(@Nullable EnumFacing from, FluidStack resource) {
        for (TankSlot tank : this.tanks.values()) {
            if (!tank.isValid(resource) || !tank.canInsert(from) || tank.getContent() != null && !tank.getContent().isFluidEqual(resource)) continue;
            return tank.getIndex();
        }
        return -1;
    }

    private int getTankIndexToDrain(@Nullable EnumFacing from, @Nullable FluidStack resource) {
        for (TankSlot tank : this.tanks.values()) {
            if (tank.getContent() == null || !tank.canExtract(from) || resource != null && !resource.isFluidEqual(tank.getContent())) continue;
            return tank.getIndex();
        }
        return -1;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("liquidTanks")) {
            NBTTagList tanksNBT = nbttagcompound.func_150295_c("liquidTanks", 10);
            for (int i = 0; i < tanksNBT.func_74745_c(); ++i) {
                NBTTagCompound tankNBT = tanksNBT.func_150305_b(i);
                int index = tankNBT.func_74762_e("index");
                if (!this.tanks.containsKey(index)) continue;
                this.tanks.get(index).readFromNBT(tankNBT);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound2) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
        NBTTagList tanksNBT = new NBTTagList();
        for (Map.Entry<Integer, TankSlot> entry : this.tanks.entrySet()) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            tankNBT.func_74768_a("index", entry.getKey().intValue());
            entry.getValue().writeToNBT(tankNBT);
            tanksNBT.func_74742_a((NBTBase)tankNBT);
        }
        nbttagcompound.func_74782_a("liquidTanks", (NBTBase)tanksNBT);
        return nbttagcompound;
    }

    @Override
    public boolean isTankReadOnly(int tank) {
        return this.tanks.get(tank).isReadOnly();
    }

    @Override
    public boolean isLiquidValidForTank(FluidStack liquid, int tank) {
        TankSlot slot = this.getTankSlot(tank);
        return slot != null && slot.isValid(liquid) && !slot.isReadOnly();
    }

    @Override
    public TankInfo[] getTankInfos() {
        return TankInfo.get(this);
    }

    @Override
    public IFluidTank getTank(int index) {
        return this.getTanks()[index];
    }

    @Override
    public IFluidTank[] getTanks() {
        ArrayList<IFluidTank> ltanks = new ArrayList<IFluidTank>();
        for (TankSlot tank : this.tanks.values()) {
            ltanks.add(tank.getTank());
        }
        return ltanks.toArray(new IFluidTank[0]);
    }

    @Override
    @Nullable
    public TankSlot getTankSlot(int index) {
        return this.tanks.get(index);
    }

    public void markDirty() {
        if (this.getMachine() != null) {
            this.getMachine().markDirty();
        }
    }

    @Override
    @Nullable
    public IFluidHandler getHandler(@Nullable EnumFacing from) {
        if (from == null) {
            return this.noFacingHandler;
        }
        return this.handlers.get(from);
    }

    private class TankContainer
    implements IFluidHandler {
        @Nullable
        private final EnumFacing from;

        public TankContainer(EnumFacing from) {
            this.from = from;
        }

        public final int fill(FluidStack resource, boolean doFill) {
            int index = ComponentTankContainer.this.getTankIndexToFill(this.from, resource);
            if (ComponentTankContainer.this.tanks.containsKey(index)) {
                return ComponentTankContainer.this.fill(index, resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            int index = ComponentTankContainer.this.getTankIndexToDrain(this.from, null);
            if (ComponentTankContainer.this.tanks.containsKey(index)) {
                return ComponentTankContainer.this.drain(index, resource.amount, doDrain);
            }
            return null;
        }

        @Nullable
        public final FluidStack drain(int maxDrain, boolean doDrain) {
            int index = ComponentTankContainer.this.getTankIndexToDrain(this.from, null);
            if (ComponentTankContainer.this.tanks.containsKey(index)) {
                return ComponentTankContainer.this.drain(index, maxDrain, doDrain);
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] properties = new IFluidTankProperties[ComponentTankContainer.this.getTanks().length];
            for (int i = 0; i < properties.length; ++i) {
                IFluidTank tank = ComponentTankContainer.this.getTanks()[i];
                properties[i] = new FluidTankProperties(tank.getFluid(), tank.getCapacity());
            }
            return properties;
        }
    }
}

