/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.multifence;

import binnie.extratrees.blocks.decor.FenceDescription;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.blocks.decor.MultiFenceRecipePattern;
import binnie.extratrees.integration.jei.multifence.MultiFenceRecipeEmbeddedWrapper;
import binnie.extratrees.integration.jei.multifence.MultiFenceRecipeSizeWrapper;
import binnie.extratrees.integration.jei.multifence.MultiFenceRecipeSolidWrapper;
import binnie.extratrees.wood.WoodManager;
import binnie.extratrees.wood.planks.IPlankType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

public class MultiFenceRecipeRegistryPlugin
implements IRecipeRegistryPlugin {
    private final List<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();

    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        Object ingredient = focus.getValue();
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ItemStack itemStack = (ItemStack)ingredient;
        switch (focus.getMode()) {
            case INPUT: {
                FenceDescription desc = WoodManager.getFenceDescription(itemStack);
                IPlankType plankType = WoodManager.getPlankType(itemStack);
                if (plankType != null || desc != null && (!desc.getFenceType().isEmbossed() || !desc.getFenceType().isEmbossed())) {
                    return Collections.singletonList("minecraft.crafting");
                }
                return Collections.emptyList();
            }
            case OUTPUT: {
                FenceDescription desc = WoodManager.getFenceDescription(itemStack);
                if (desc != null) {
                    return Collections.singletonList("minecraft.crafting");
                }
                return Collections.emptyList();
            }
        }
        return Collections.singletonList("minecraft.crafting");
    }

    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object ingredient = focus.getValue();
        if (!recipeCategory.getUid().equals("minecraft.crafting") || !(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        return this.getRecipes(focus);
    }

    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        if (!recipeCategory.getUid().equals("minecraft.crafting")) {
            return Collections.emptyList();
        }
        if (this.recipes.isEmpty()) {
            for (MultiFenceRecipePattern pattern : MultiFenceRecipePattern.VALUES) {
                this.recipes.add(new MultiFenceRecipeSizeWrapper(pattern));
            }
            for (FenceType fenceType : FenceType.getValues()) {
                this.recipes.add((IRecipeWrapper)new MultiFenceRecipeEmbeddedWrapper(fenceType));
                this.recipes.add((IRecipeWrapper)new MultiFenceRecipeSolidWrapper(fenceType));
            }
        }
        return this.recipes;
    }

    private List<IRecipeWrapper> getRecipes(IFocus<ItemStack> focus) {
        ItemStack ingredient = (ItemStack)focus.getValue();
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        if (focus.getMode() == IFocus.Mode.INPUT) {
            IPlankType plankType = WoodManager.getPlankType(ingredient);
            if (plankType != null) {
                for (MultiFenceRecipePattern pattern : MultiFenceRecipePattern.VALUES) {
                    recipes.add(new MultiFenceRecipeSizeWrapper(pattern, plankType));
                }
                for (int size = 0; size < 3; ++size) {
                    for (boolean solid : new boolean[]{false, true}) {
                        recipes.add((IRecipeWrapper)new MultiFenceRecipeEmbeddedWrapper(plankType, new FenceType(size, solid, false)));
                    }
                }
            } else {
                FenceDescription desc = WoodManager.getFenceDescription(ingredient);
                if (desc != null) {
                    if (!desc.getFenceType().isEmbossed()) {
                        recipes.add((IRecipeWrapper)new MultiFenceRecipeEmbeddedWrapper(desc));
                    }
                    if (!desc.getFenceType().isSolid()) {
                        recipes.add((IRecipeWrapper)new MultiFenceRecipeSolidWrapper(desc));
                    }
                }
            }
        } else {
            FenceDescription desc = WoodManager.getFenceDescription(ingredient);
            if (desc != null) {
                int size = desc.getFenceType().getSize();
                recipes.add(new MultiFenceRecipeSizeWrapper(MultiFenceRecipePattern.VALUES[size * 2], desc.getPlankType(), desc.getSecondaryPlankType()));
                recipes.add(new MultiFenceRecipeSizeWrapper(MultiFenceRecipePattern.VALUES[size * 2 + 1], desc.getPlankType(), desc.getSecondaryPlankType()));
                if (desc.getFenceType().isEmbossed()) {
                    recipes.add((IRecipeWrapper)new MultiFenceRecipeEmbeddedWrapper(desc));
                }
                if (desc.getFenceType().isSolid()) {
                    recipes.add((IRecipeWrapper)new MultiFenceRecipeSolidWrapper(desc));
                }
            }
        }
        return recipes;
    }
}

