/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.errors;

import binnie.core.machines.errors.EnumErrorType;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.util.I18N;
import javax.annotation.Nullable;

public enum CoreErrorCode implements IErrorStateDefinition
{
    UNKNOWN("unknown"),
    NO_ITEM("no.item", EnumErrorType.ITEM),
    NO_SPACE("no.space", EnumErrorType.ITEM),
    NO_SPACE_TANK("no.space.tank", NO_SPACE),
    INVALID_ITEM("invalid.item", EnumErrorType.ITEM),
    INSUFFICIENT_POWER("insufficient.power", EnumErrorType.POWER),
    TANK_FULL("tank.full", EnumErrorType.TANK),
    TANK_EMPTY("tank.empty", EnumErrorType.TANK),
    TANK_DIFFRENT_FLUID("tank.different", NO_SPACE_TANK),
    INSUFFICIENT_LIQUID("insufficient.liquid", EnumErrorType.TANK),
    NO_RECIPE("no.recipe"),
    INVALID_RECIPE("invalid.recipe"),
    TASK_CANCELLED("task.cancelled"),
    TASK_PAUSED("task.paused");

    private final String name;
    private final IErrorStateDefinition parent;
    private final EnumErrorType type;

    private CoreErrorCode(String name) {
        this(name, null, EnumErrorType.NONE);
    }

    private CoreErrorCode(String name, EnumErrorType type) {
        this(name, null, type);
    }

    private CoreErrorCode(String name, IErrorStateDefinition parent) {
        this(name, parent, EnumErrorType.NONE);
    }

    private CoreErrorCode(String name, IErrorStateDefinition parent, EnumErrorType type) {
        this.name = name;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public String getDescription() {
        return I18N.localise("binniecore.errors." + this.name + ".desc");
    }

    @Override
    public String getName() {
        return I18N.localise("binniecore.errors." + this.name + ".name");
    }

    @Override
    public String getUID() {
        return "binniecore:" + this.name;
    }

    @Override
    @Nullable
    public EnumErrorType getType() {
        if (this.parent != null) {
            return this.parent.getType();
        }
        return this.type;
    }
}

