/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.transfer;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.IValidatedTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ITankMachine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TransferRequest {
    private ItemStack itemToTransfer = ItemStack.field_190927_a;
    private ItemStack returnItem = ItemStack.field_190927_a;
    @Nullable
    private IInventory origin;
    @Nullable
    private IInventory destination;
    private int[] targetSlots = new int[0];
    private int[] targetTanks = new int[0];
    private boolean transferLiquids = true;
    private boolean ignoreReadOnly = false;
    private final List<TransferSlot> insertedSlots = new ArrayList<TransferSlot>();
    private final List<Integer> insertedTanks = new ArrayList<Integer>();

    public TransferRequest(ItemStack toTransfer, IInventory destination) {
        int[] target = new int[destination.func_70302_i_()];
        for (int i = 0; i < target.length; ++i) {
            target[i] = i;
        }
        int[] targetTanks = new int[]{};
        if (destination instanceof ITankMachine) {
            targetTanks = new int[((ITankMachine)destination).getTanks().length];
            for (int j = 0; j < targetTanks.length; ++j) {
                targetTanks[j] = j;
            }
        }
        if (!toTransfer.func_190926_b()) {
            this.setItemToTransfer(toTransfer.func_77946_l());
            this.setReturnItem(toTransfer.func_77946_l());
        }
        this.setOrigin(null);
        this.setDestination(destination);
        this.setTargetSlots(target);
        this.setTargetTanks(targetTanks);
        this.transferLiquids = true;
    }

    public static ItemStack transferItemToInventory(ItemStack item, IInventory destination, boolean doAdd) {
        ItemStack addition = item.func_77946_l();
        int i = 0;
        while (i < destination.func_70302_i_()) {
            if (!(addition = TransferRequest.transferToInventory(addition, destination, new int[]{i++}, doAdd, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return addition;
    }

    public static ItemStack transferToInventory(ItemStack item, IInventory destination, int[] targetSlots, boolean doAdd, boolean ignoreValidation) {
        ItemStack returnItem = item;
        for (int i : targetSlots) {
            if (!destination.func_94041_b(i, returnItem) && !ignoreValidation) continue;
            ItemStack stackInSlot = destination.func_70301_a(i);
            if (stackInSlot.func_190926_b()) {
                if (doAdd) {
                    destination.func_70299_a(i, returnItem.func_77946_l());
                }
                return ItemStack.field_190927_a;
            }
            if (!returnItem.func_77985_e()) continue;
            ItemStack merged = stackInSlot.func_77946_l();
            NonNullList<ItemStack> newStacks = TransferRequest.mergeStacks(returnItem.func_77946_l(), merged.func_77946_l());
            returnItem = (ItemStack)newStacks.get(0);
            if (!doAdd) continue;
            destination.func_70299_a(i, (ItemStack)newStacks.get(1));
        }
        return returnItem;
    }

    private static boolean areItemsEqual(ItemStack merged, ItemStack itemstack) {
        return ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)merged) && itemstack.func_77969_a(merged);
    }

    public static NonNullList<ItemStack> mergeStacks(ItemStack itemstack, ItemStack merged) {
        int space;
        if (TransferRequest.areItemsEqual(itemstack, merged) && (space = merged.func_77976_d() - merged.func_190916_E()) > 0) {
            if (itemstack.func_190916_E() > space) {
                itemstack.func_190918_g(space);
                merged.func_190917_f(space);
            } else if (itemstack.func_190916_E() <= space) {
                merged.func_190917_f(itemstack.func_190916_E());
                itemstack = ItemStack.field_190927_a;
            }
        }
        NonNullList result = NonNullList.func_191196_a();
        result.add((Object)itemstack);
        result.add((Object)merged);
        return result;
    }

    public static ItemStack transferToTank(ItemStack itemStack, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        FluidStack containerLiquid;
        Preconditions.checkNotNull((Object)itemStack);
        Preconditions.checkArgument((itemStack.func_190916_E() >= 1 ? 1 : 0) != 0);
        ItemStack singleCopy = itemStack.func_77946_l();
        singleCopy.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)singleCopy);
        if (fluidHandler != null && (containerLiquid = fluidHandler.drain(Integer.MAX_VALUE, false)) != null && containerLiquid.amount > 0) {
            IFluidTank tank = destination.getTanks()[tankID];
            IValidatedTankContainer validated = Machine.getInterface(IValidatedTankContainer.class, destination);
            if (validated == null || validated.isLiquidValidForTank(containerLiquid, tankID)) {
                int amountAdded = tank.fill(containerLiquid, false);
                fluidHandler.drain(amountAdded, true);
                ItemStack drainedContainer = fluidHandler.getContainer();
                if (drainedContainer.func_190926_b() || TransferRequest.transferItemToInventory(singleCopy, origin, false).func_190926_b()) {
                    if (doAdd) {
                        tank.fill(containerLiquid, true);
                        if (!drainedContainer.func_190926_b()) {
                            TransferRequest.transferItemToInventory(drainedContainer, origin, true);
                        }
                    }
                    ItemStack leftover = itemStack.func_77946_l();
                    leftover.func_190918_g(1);
                    return leftover;
                }
            }
        }
        return itemStack;
    }

    private static ItemStack transferFromTank(ItemStack itemStack, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        Preconditions.checkNotNull((Object)itemStack);
        Preconditions.checkArgument((itemStack.func_190916_E() >= 1 ? 1 : 0) != 0);
        IFluidTank tank = destination.getTanks()[tankID];
        FluidStack fluid = tank.getFluid();
        if (fluid != null) {
            FluidStack fillFluid;
            int fillAmount;
            ItemStack singleCopy = itemStack.func_77946_l();
            singleCopy.func_190920_e(1);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)singleCopy);
            if (fluidHandler != null && (fillAmount = fluidHandler.fill(fluid, true)) > 0 && (fillFluid = tank.drain(fillAmount, false)) != null) {
                fluidHandler.fill(fillFluid, true);
                ItemStack filledContainer = fluidHandler.getContainer();
                if (filledContainer.func_190926_b() || TransferRequest.transferItemToInventory(singleCopy, origin, false).func_190926_b()) {
                    if (doAdd) {
                        tank.drain(fillFluid.amount, true);
                        if (!filledContainer.func_190926_b()) {
                            TransferRequest.transferItemToInventory(filledContainer, origin, true);
                        }
                    }
                    ItemStack leftover = itemStack.func_77946_l();
                    leftover.func_190918_g(1);
                    return leftover;
                }
            }
        }
        return itemStack;
    }

    public TransferRequest ignoreValidation() {
        this.ignoreReadOnly = true;
        return this;
    }

    public ItemStack getReturnItem() {
        return this.returnItem;
    }

    private void setReturnItem(ItemStack returnItem) {
        this.returnItem = returnItem;
    }

    public ItemStack transfer(boolean doAdd) {
        ItemStack item = this.returnItem;
        if (item.func_190926_b() || this.destination == null) {
            return ItemStack.field_190927_a;
        }
        if (this.transferLiquids && this.destination instanceof ITankMachine) {
            int tankID;
            if (this.origin == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemIn = item.func_77946_l();
            int[] nArray = this.targetTanks;
            int n = nArray.length;
            for (int i = 0; i < n && !(item = TransferRequest.transferToTank(item, this.origin, (ITankMachine)this.destination, tankID = nArray[i], doAdd)).func_190926_b() && ItemStack.func_77989_b((ItemStack)item, (ItemStack)itemIn) && !(item = TransferRequest.transferFromTank(item, this.origin, (ITankMachine)this.destination, tankID, doAdd)).func_190926_b() && ItemStack.func_77989_b((ItemStack)item, (ItemStack)itemIn); ++i) {
            }
        }
        if (!item.func_190926_b()) {
            for (int slot : this.targetSlots) {
                ItemStack stackInSlot;
                InventorySlot inventorySlot;
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && (inventorySlot = ((IInventorySlots)this.destination).getSlot(slot)) != null && inventorySlot.isRecipe() || (stackInSlot = this.destination.func_70301_a(slot)).func_190926_b() || !item.func_77985_e()) continue;
                ItemStack merged = stackInSlot.func_77946_l();
                NonNullList<ItemStack> newStacks = TransferRequest.mergeStacks(item.func_77946_l(), merged.func_77946_l());
                item = (ItemStack)newStacks.get(0);
                if (!TransferRequest.areItemsEqual(merged, (ItemStack)newStacks.get(1))) {
                    this.insertedSlots.add(new TransferSlot(slot, this.destination));
                }
                if (doAdd) {
                    this.destination.func_70299_a(slot, (ItemStack)newStacks.get(1));
                }
                if (!item.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (!item.func_190926_b()) {
            for (int slot : this.targetSlots) {
                InventorySlot inventorySlot;
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && (inventorySlot = ((IInventorySlots)this.destination).getSlot(slot)) != null && inventorySlot.isRecipe() || !this.destination.func_70301_a(slot).func_190926_b()) continue;
                this.insertedSlots.add(new TransferSlot(slot, this.destination));
                if (doAdd) {
                    this.destination.func_70299_a(slot, item.func_77946_l());
                }
                return ItemStack.field_190927_a;
            }
        }
        this.setReturnItem(item);
        return this.getReturnItem();
    }

    public List<TransferSlot> getInsertedSlots() {
        return this.insertedSlots;
    }

    public List<Integer> getInsertedTanks() {
        return this.insertedTanks;
    }

    @Nullable
    public IInventory getOrigin() {
        return this.origin;
    }

    public TransferRequest setOrigin(@Nullable IInventory origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public IInventory getDestination() {
        return this.destination;
    }

    private void setDestination(IInventory destination) {
        this.destination = destination;
    }

    public ItemStack getItemToTransfer() {
        return this.itemToTransfer;
    }

    private void setItemToTransfer(ItemStack itemToTransfer) {
        this.itemToTransfer = itemToTransfer;
    }

    public int[] getTargetSlots() {
        return this.targetSlots;
    }

    public TransferRequest setTargetSlots(int[] targetSlots) {
        this.targetSlots = targetSlots;
        return this;
    }

    public int[] getTargetTanks() {
        return this.targetTanks;
    }

    public TransferRequest setTargetTanks(int[] targetTanks) {
        this.targetTanks = targetTanks;
        return this;
    }

    public static class TransferSlot {
        private final int id;
        private final IInventory inventory;

        public TransferSlot(int id, IInventory inventory) {
            this.id = id;
            this.inventory = inventory;
        }

        public int getId() {
            return this.id;
        }

        public IInventory getInventory() {
            return this.inventory;
        }
    }
}

