/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.ModId;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.KeyBindings;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.core.util.I18N;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlHelp
extends Control
implements ITooltip {
    public ControlHelp(IWidget parent, int x, int y) {
        super(parent, x, y, 16, 16);
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.HELP_BUTTON, this.getArea());
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        this.getTooltip(tooltip);
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        this.getTooltip(tooltip);
    }

    private void getTooltip(Tooltip tooltip) {
        tooltip.setMaxWidth(140);
        tooltip.setType(Tooltip.Type.HELP);
        tooltip.add(I18N.localise(ModId.CORE, "gui.help.title", new Object[0]));
        tooltip.add(I18N.localise(ModId.CORE, "gui.help.desc", KeyBindings.holdForHelpTooltips.getDisplayName()));
    }
}

