/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.modules;

import binnie.core.modules.IConfigHandler;
import binnie.core.modules.IModuleContainer;
import binnie.core.modules.Module;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ModuleContainer
implements IModuleContainer {
    protected final Set<Module> loadedModules;
    protected final Set<Module> unloadedModules;
    protected final Set<String> enabledModules;
    protected final File configFolder;
    protected final Configuration configModules;
    protected final String modId;
    protected final ContainerState state;
    protected final Set<IConfigHandler> configHandlers;

    public ModuleContainer(String modId, ContainerState state) {
        this.modId = modId;
        this.state = state;
        this.loadedModules = new LinkedHashSet<Module>();
        this.unloadedModules = new LinkedHashSet<Module>();
        this.enabledModules = new LinkedHashSet<String>();
        this.configFolder = new File(Loader.instance().getConfigDir(), "forestry/" + modId);
        this.configModules = new Configuration(new File(this.configFolder, "modules.cfg"));
        this.configHandlers = new HashSet<IConfigHandler>();
    }

    protected void runPreInit(FMLPreInitializationEvent event) {
        for (Module module : this.loadedModules) {
            module.registerItemsAndBlocks();
        }
        for (Module module : this.loadedModules) {
            module.preInit();
        }
    }

    public void runInit(FMLInitializationEvent event) {
        for (Module module : this.loadedModules) {
            module.init();
        }
        for (IConfigHandler handler : this.configHandlers) {
            handler.loadConfig();
        }
    }

    public void runPostInit(FMLPostInitializationEvent event) {
        for (Module module : this.loadedModules) {
            module.postInit();
        }
    }

    @Override
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        for (IConfigHandler handler : this.configHandlers) {
            handler.loadConfig();
        }
    }

    @Override
    public final boolean isModuleEnabled(String moduleUID) {
        return this.enabledModules.contains(moduleUID);
    }

    @Override
    public String getID() {
        return this.modId;
    }

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    public Configuration getModulesConfig() {
        return this.configModules;
    }

    @Override
    public void enableModule(String uid) {
        this.enabledModules.add(uid);
    }

    @Override
    public Set<Module> getLoadedModules() {
        return this.loadedModules;
    }

    @Override
    public Set<Module> getUnloadedModules() {
        return this.unloadedModules;
    }

    @Override
    public void registerConfigHandler(IConfigHandler handler) {
        this.configHandlers.add(handler);
    }

    @Override
    public boolean isAvailable() {
        return this.state.isAvailable();
    }

    public static interface ContainerState {
        public boolean isAvailable();
    }
}

