/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.ITextureManager;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WoodProvider
implements IWoodProvider {
    private final IWoodType type;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private TextureAtlasSprite trunk;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private TextureAtlasSprite bark;

    public WoodProvider(IWoodType type) {
        this.type = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(Item item, ITextureManager manager) {
        TextureMap textureMap = FMLClientHandler.instance().getClient().func_147117_R();
        this.trunk = textureMap.func_174942_a(new ResourceLocation(this.type.getHeartTexture()));
        this.bark = textureMap.func_174942_a(new ResourceLocation(this.type.getBarkTexture()));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(boolean isTop) {
        if (isTop) {
            Preconditions.checkState((this.trunk != null ? 1 : 0) != 0, (Object)"sprites have not been registered");
            return this.trunk;
        }
        Preconditions.checkState((this.bark != null ? 1 : 0) != 0, (Object)"sprites have not been registered");
        return this.bark;
    }

    public ItemStack getWoodStack() {
        return TreeManager.woodAccess.getStack(this.type, WoodBlockKind.LOG, false);
    }

    public int getCarbonization() {
        return this.type.getCarbonization();
    }

    public float getCharcoalChance(int numberOfCharcoal) {
        return this.type.getCharcoalChance(numberOfCharcoal);
    }
}

