/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.ManagerBase;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ValidatorSprite;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

public class ManagerMachine
extends ManagerBase {
    private static ValidatorSprite spriteBee;
    private static ValidatorSprite spriteFrame;
    private static ValidatorSprite spriteCircuit;
    private static ValidatorSprite spriteBlock;
    private final Map<Class<?>, Class<?>[]> componentInterfaceMap = new HashMap();
    private final Map<String, MachineGroup> machineGroups = new HashMap<String, MachineGroup>();
    private int nextNetworkID = 0;

    public static ValidatorSprite getSpriteBee() {
        return spriteBee;
    }

    public static ValidatorSprite getSpriteFrame() {
        return spriteFrame;
    }

    public static ValidatorSprite getSpriteCircuit() {
        return spriteCircuit;
    }

    public static ValidatorSprite getSpriteBlock() {
        return spriteBlock;
    }

    public void registerMachineGroup(MachineGroup group) {
        this.machineGroups.put(group.getUID(), group);
    }

    public MachineGroup getGroup(String name) {
        return this.machineGroups.get(name);
    }

    public MachinePackage getPackage(String group, String name) {
        MachineGroup machineGroup = this.getGroup(group);
        return machineGroup == null ? null : machineGroup.getPackage(name);
    }

    private void registerComponentClass(Class<? extends MachineComponent> component) {
        if (this.componentInterfaceMap.containsKey(component)) {
            return;
        }
        HashSet interfaces = new HashSet();
        for (Class<? extends MachineComponent> currentClass = component; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Collections.addAll(interfaces, currentClass.getInterfaces());
        }
        interfaces.remove(INbtWritable.class);
        interfaces.remove(INbtReadable.class);
        this.componentInterfaceMap.put(component, interfaces.toArray(new Class[0]));
        int networkID = this.nextNetworkID++;
    }

    @Override
    public void preInit() {
        spriteBee = new ValidatorSprite(BinnieCore.getInstance(), "validator/bee.0", "validator/bee.1");
        spriteFrame = new ValidatorSprite(BinnieCore.getInstance(), "validator/frame.0", "validator/frame.1");
        spriteCircuit = new ValidatorSprite(BinnieCore.getInstance(), "validator/circuit.0", "validator/circuit.1");
        spriteBlock = new ValidatorSprite(BinnieCore.getInstance(), "validator/block.0", "validator/block.1");
    }

    @Override
    public void postInit() {
        Object rendererMachine = null;
        BinnieCore.getBinnieProxy().registerTileEntity(TileEntityMachine.class, "binnie.tile.machine", rendererMachine);
    }

    @Nullable
    public Class<?>[] getComponentInterfaces(Class<? extends MachineComponent> clss) {
        if (!this.componentInterfaceMap.containsKey(clss)) {
            this.registerComponentClass(clss);
        }
        return this.componentInterfaceMap.get(clss);
    }
}

