/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.renderer;

import binnie.core.BinnieCore;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IPoint;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    private RenderUtil() {
    }

    public static void drawItem(Point pos, ItemStack itemStack) {
        RenderUtil.drawItem(pos, itemStack, false);
    }

    public static void drawItem(Point pos, ItemStack itemStack, boolean rotating) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179126_j();
        GlStateManager.func_179123_a();
        Preconditions.checkNotNull((Object)itemStack);
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderHelper.func_74520_c();
        RenderItem renderItem = minecraft.func_175599_af();
        FontRenderer font = RenderUtil.getFontRenderer(minecraft, itemStack);
        if (rotating) {
            GlStateManager.func_179094_E();
            float phase = Minecraft.func_71386_F() / 20L;
            GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)150.0f);
            GlStateManager.func_179114_b((float)phase, (float)0.0f, (float)-0.866f, (float)0.5f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-150.0f);
        }
        renderItem.func_184391_a(null, itemStack, pos.xPos(), pos.yPos());
        if (rotating) {
            GlStateManager.func_179121_F();
        }
        renderItem.func_180453_a(font, itemStack, pos.xPos(), pos.yPos(), null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
    }

    private static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        FontRenderer fontRenderer = ingredient.func_77973_b().getFontRenderer(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public static void drawTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void setColour(int hexColour) {
        int a = (hexColour & 0xFF000000) >> 24;
        int r = (hexColour & 0xFF0000) >> 16;
        int g = (hexColour & 0xFF00) >> 8;
        int b = hexColour & 0xFF;
        if (a < 0) {
            a += 256;
        }
        if (a > 0 && a != 255) {
            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        } else {
            GlStateManager.func_179124_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
        }
    }

    public static int getTextWidth(String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        return fontRenderer.func_78256_a(text);
    }

    public static int getTextHeight() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        return fontRenderer == null ? 0 : fontRenderer.field_78288_b;
    }

    public static void drawText(IPoint pos, String text, int colour) {
        RenderUtil.drawText(new Area(pos, new Point(500, 500)), TextJustification.TOP_LEFT, text, colour);
    }

    public static void drawText(IArea area, TextJustification justification, String text, int colour) {
        IPoint pos = area.pos();
        if ((float)area.size().xPos() <= 0.0f) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List wrappedStrings = fontRenderer.func_78271_c(text, area.size().xPos());
        float totalHeight = wrappedStrings.size() * RenderUtil.getTextHeight();
        float posY = pos.yPos();
        if ((float)area.size().yPos() > totalHeight) {
            posY += ((float)area.size().yPos() - totalHeight) * justification.getYOffset();
        }
        for (String string : wrappedStrings) {
            float stringWidth = RenderUtil.getTextWidth(string);
            float posX = (float)area.size().xPos() - stringWidth;
            GlStateManager.func_179097_i();
            fontRenderer.func_78276_b(string, (int)((float)pos.xPos() + (posX *= justification.getXOffset())), (int)posY, colour);
            posY += (float)RenderUtil.getTextHeight();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSolidRect(float left, float top, float right, float bottom, int color) {
        GuiUtils.drawGradientRect((int)0, (int)((int)left), (int)((int)top), (int)((int)right), (int)((int)bottom), (int)color, (int)color);
    }

    public static void drawSolidRect(IArea area, int colour) {
        RenderUtil.drawSolidRect(area.pos().xPos(), area.pos().yPos(), area.pos().xPos() + area.size().xPos(), area.pos().yPos() + area.size().yPos(), 0xFF000000 | colour);
    }

    public static void drawSolidRectWithAlpha(IArea area, int color) {
        RenderUtil.drawSolidRect(area.pos().xPos(), area.pos().yPos(), area.pos().xPos() + area.size().xPos(), area.pos().yPos() + area.size().yPos(), color);
    }

    public static void drawGradientRect(IArea area, int startColor, int endColor) {
        GuiUtils.drawGradientRect((int)0, (int)area.pos().xPos(), (int)area.pos().yPos(), (int)(area.pos().xPos() + area.size().xPos()), (int)(area.pos().yPos() + area.size().yPos()), (int)startColor, (int)endColor);
    }

    public static void drawSprite(Point pos, @Nullable TextureAtlasSprite icon) {
        if (icon != null) {
            BinnieCore.getBinnieProxy().bindTexture(TextureMap.field_110575_b);
            RenderUtil.drawTexture(pos.xPos(), pos.yPos(), icon, 0, 0, 0.0);
        }
    }

    public static void drawGuiSprite(Point pos, @Nullable TextureAtlasSprite icon) {
        if (icon != null) {
            BinnieCore.getBinnieProxy().bindTexture(ForestryAPI.textureManager.getGuiTextureMap());
            RenderUtil.drawTexture(pos.xPos(), pos.yPos(), icon, 0, 0, 0.0);
        }
    }

    public static void drawFluid(Point pos, @Nullable FluidStack fluidStack) {
        Fluid fluid;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null) {
            TextureAtlasSprite stillSprite = RenderUtil.getStillFluidSprite(minecraft, fluid);
            int fluidColor = fluid.getColor(fluidStack);
            minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            RenderUtil.setColour(fluidColor);
            RenderUtil.drawTexture(pos.xPos(), pos.yPos(), stillSprite, 0, 0, 100.0);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private static TextureAtlasSprite getStillFluidSprite(Minecraft minecraft, Fluid fluid) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        return fluidStillSprite;
    }
}

